<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor titpori3 Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_title3_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve titpori3 widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'titpori33';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve titpori3 widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'عنوان سه', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve titpori3 widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the titpori3 widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register titpori3 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
		$this->add_control(
			'titpori3_img',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
        // titpori3 Sub Title
		$this->add_control(
			'titpori3_sub_title',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'placeholder' => __( 'زیر عنوان', 'Bina-extension' ),
				'default'     => esc_html__( ' خدمات شرکت بینا ' ),
                'separator'=> 'before',
			]
        );
        // titpori3 Title
		$this->add_control(
			'titpori3_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'خدمات ویژه' ),
				'placeholder' => __( '', 'Bina-extension' ),
			]
        );

		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		
        // Sub Title Options
		$this->add_control(
			'titpori3e_subtitle_heading',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'titpori3e_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001957',
				'selectors' => [
					'{{WRAPPER}} .pori-tit-sc.with-image.with-sub-title h3' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'titpori3e_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-tit-sc.with-image.with-sub-title h3',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001957',
				'selectors' => [
					'{{WRAPPER}} .pori-tit-sc.with-image.with-sub-title h2' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-tit-sc.with-image.with-sub-title h2',
			]
        );

		
        
        $this->end_controls_section();
	}

	/**
	 * Render titpori3 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HporiL.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $titpori3_sub_title = $settings['titpori3_sub_title'];
		$titpori3_sub_title2 = $settings['titpori3_sub_title2'];
        $titpori3_title = $settings['titpori3_title'];
		$titpori3_img = $settings['titpori3_img']['url'];

		
    ?>
	

	<div class="pori-tit-sc with-image with-sub-title">
    <p><img src="<?php echo $titpori3_img;?>" class="attachment-full" alt="" loading="lazy" width="27" height="27" /></p>
    <h2><?php echo $titpori3_title; ?></h2>
    <h3><?php echo $titpori3_sub_title; ?></h3>
</div>

	

<?php
	}

}