<?php

/**
 * Plugin Row Meta / Hooks
 *
 * @package  Masoud darvishi (THEMEFOUR.COM)
 * @category Enqueue
 * @author   ThemeFour Team
 * @license  GPL-2.0
 */

	
add_filter( 'plugin_row_meta', 'themefour_meta_row_wordpress_seo_premium', 10, 2 );
  function themefour_meta_row_wordpress_seo_premium( $links, $file ) {    
    if ( $file === 'wordpress-seo-premium/wp-seo-premium.php' ) {
		if (get_locale() == 'fa_IR'){
		$links[] = '<a href="https://themefour.com/" target="_blank" title="themefour.com"><strong>نگارش تم فور</strong></a>';
		}else{
		$links[] = '<a href="https://themefour.com/" target="_blank" title="themefour.com"><strong>themefour</strong></a>';
		}
        return array_merge( $links );
    }
    return (array) $links;
}

$site_information = get_transient( 'wpseo_site_information' );
if ( isset( $site_information->subscriptions ) && ( count( $site_information->subscriptions ) == 0 ) ) {
    delete_transient( 'wpseo_site_information' );
    delete_transient( 'wpseo_site_information_quick' );
}

add_filter( 'pre_http_request', function( $pre, $parsed_args, $url ){
    $site_information = (object) [
        'subscriptions' => [
            (object) [
                'product' => (object) [ 'slug' => 'yoast-seo-wordpress-premium' ],
                'expiryDate' => '+5 years'
            ],

            (object) [
                'product' => (object) [ 'slug' => 'yoast-seo-news' ],
                'expiryDate' => '+5 years'
            ],
            (object) [
                'product' => (object) [ 'slug' => 'yoast-seo-woocommerce' ],
                'expiryDate' => '+5 years'
            ],
            (object) [
                'product' => (object) [ 'slug' => 'yoast-seo-video' ],
                'expiryDate' => '+5 years'
            ],
            (object) [
                'product' => (object) [ 'slug' => 'yoast-seo-local' ],
                'expiryDate' => '+5 years'
            ]
        ],
    ];

    if ( strpos( $url, 'https://my.yoast.com/api/sites/current' ) !== false ) {
        return [
            'response' => [ 'code' => 200, 'message' => 'OK' ],
            'body'     => json_encode( $site_information )
        ];
    } else {
        return $pre;
    }
}, 10, 3 );