var yp_qrcode = {};

function init_tabs() {
	if(window.location.hash!='') {
		$('.tab_content').hide();
		$('.tabs a').removeClass("selected");
		var id=window.location.hash;
		id = id.substr(1);
		$('[rel='+id+']').addClass("selected");
		yp_qrcode.type=id;
		$('#'+id).show();
	}
	else {
		select_tab($('.current'));
	}
}

function select_tab(obj) {
	$('.tab_content').hide();
	$('.tabs a').removeClass("selected");
	
	var id;
	id = obj.attr("rel");
	$('[rel='+id+']').addClass("selected");
	yp_qrcode.type=id;
	$('#'+id).show();
	
	obj.addClass("selected");
}

$('#generate_qrcode_btn').live('click', function(event) {
	event.preventDefault();
	
	yp_qrcode.qrcode_encoding = encodeURIComponent($('#qrcode_encoding').val());
	yp_qrcode.qrcode_width = encodeURIComponent($('#qrcode_width').val());
	yp_qrcode.qrcode_height = encodeURIComponent($('#qrcode_height').val());
	yp_qrcode.qrcode_correction = encodeURIComponent($('#qrcode_correction').val());
	
	yp_qrcode.text = encodeURIComponent($('#qrcode_text').val());
	yp_qrcode.email = encodeURIComponent($('#qrcode_email').val());
	yp_qrcode.subject = encodeURIComponent($('#qrcode_subject').val());
	yp_qrcode.message = encodeURIComponent($('#qrcode_message').val());
	yp_qrcode.tel = encodeURIComponent($('#qrcode_tel').val());
	yp_qrcode.url = encodeURIComponent($('#qrcode_url').val());
	
	if(yp_qrcode.type=='mecard') {
		yp_qrcode.mecard_fname = encodeURIComponent($('#qrcode_mecard_fname').val());
		yp_qrcode.mecard_lname = encodeURIComponent($('#qrcode_mecard_lname').val());
		yp_qrcode.mecard_street = encodeURIComponent($('#qrcode_mecard_street').val());
		yp_qrcode.mecard_city = encodeURIComponent($('#qrcode_mecard_city').val());
		yp_qrcode.mecard_state = encodeURIComponent($('#qrcode_mecard_state').val());
		yp_qrcode.mecard_zip = encodeURIComponent($('#qrcode_mecard_zip').val());
		yp_qrcode.mecard_country = encodeURIComponent($('#qrcode_mecard_country').val());
		yp_qrcode.mecard_tel = encodeURIComponent($('#qrcode_mecard_tel').val());
		yp_qrcode.mecard_email = encodeURIComponent($('#qrcode_mecard_email').val());
		yp_qrcode.mecard_url = encodeURIComponent($('#qrcode_mecard_url').val());
		yp_qrcode.mecard_note = encodeURIComponent($('#qrcode_mecard_note').val());
	}
	
	else if(yp_qrcode.type=='vcard') {
		yp_qrcode.vcard_fname = encodeURIComponent($('#qrcode_vcard_fname').val());
		yp_qrcode.vcard_lname = encodeURIComponent($('#qrcode_vcard_lname').val());
		yp_qrcode.vcard_org = encodeURIComponent($('#qrcode_vcard_org').val());
		yp_qrcode.vcard_title = encodeURIComponent($('#qrcode_vcard_title').val());
		yp_qrcode.vcard_street = encodeURIComponent($('#qrcode_vcard_street').val());
		yp_qrcode.vcard_city = encodeURIComponent($('#qrcode_vcard_city').val());
		yp_qrcode.vcard_state = encodeURIComponent($('#qrcode_vcard_state').val());
		yp_qrcode.vcard_zip = encodeURIComponent($('#qrcode_vcard_zip').val());
		yp_qrcode.vcard_country = encodeURIComponent($('#qrcode_vcard_country').val());
		yp_qrcode.vcard_tel = encodeURIComponent($('#qrcode_vcard_tel').val());
		yp_qrcode.vcard_email = encodeURIComponent($('#qrcode_vcard_email').val());
		yp_qrcode.vcard_url = encodeURIComponent($('#qrcode_vcard_url').val());
		yp_qrcode.vcard_note = encodeURIComponent($('#qrcode_vcard_note').val());
	}
	
	else if(yp_qrcode.type=='sms') {
		yp_qrcode.sms_tel = encodeURIComponent($('#qrcode_sms_tel').val());
		yp_qrcode.sms_message = encodeURIComponent($('#qrcode_sms_message').val());
	}
	
	else if(yp_qrcode.type=='geo') {
		yp_qrcode.geo_address = $('#qrcode_geo_address').val();
		yp_qrcode.geo_lat = encodeURIComponent($('#qrcode_geo_lat').val());
		yp_qrcode.geo_lng = encodeURIComponent($('#qrcode_geo_lng').val());
	}
	
	else if(yp_qrcode.type=='bookmark') {
		yp_qrcode.bkm_title = encodeURIComponent($('#qrcode_bkm_title').val());
		yp_qrcode.bkm_url = encodeURIComponent($('#qrcode_bkm_url').val());
	}
	
	else if(yp_qrcode.type=='wifi') {
		yp_qrcode.wifi_ssid = encodeURIComponent($('#qrcode_wifi_ssid').val());
		yp_qrcode.wifi_password = encodeURIComponent($('#qrcode_wifi_password').val());
		yp_qrcode.wifi_type = encodeURIComponent($('#qrcode_wifi_type').val());
	}
	
	if(yp_qrcode.type=='geo') {
		format_qrcode_data();
	}
	else {
		format_qrcode_data();
		generate_qrcode();
	}
});

function format_qrcode_data() {
	
	if(yp_qrcode.type=='email') {
		yp_qrcode.ch = 'MATMSG:TO:'+yp_qrcode.email+';SUB:'+yp_qrcode.subject+';BODY:'+yp_qrcode.message+';;';
	}
	
	else if(yp_qrcode.type=='tel') {
		yp_qrcode.ch = 'tel:'+yp_qrcode.tel;
	}
	
	else if(yp_qrcode.type=='url') {
		yp_qrcode.ch = yp_qrcode.url;
	}
	
	else if(yp_qrcode.type=='mecard') {
		yp_qrcode.ch = 'MECARD:';
		yp_qrcode.ch += 'N:'+yp_qrcode.mecard_lname+','+yp_qrcode.mecard_fname+';';
		if(yp_qrcode.mecard_tel!='') yp_qrcode.ch += 'TEL:'+yp_qrcode.mecard_tel+';';
		yp_qrcode.ch += 'ADR:,,'+yp_qrcode.mecard_street+','+yp_qrcode.mecard_city+','+yp_qrcode.mecard_state+','+yp_qrcode.mecard_zip+','+yp_qrcode.mecard_country+';';
		if(yp_qrcode.mecard_email!='') yp_qrcode.ch += 'EMAIL:'+yp_qrcode.mecard_email+';';
		if(yp_qrcode.mecard_url!='') yp_qrcode.ch += 'URL:'+yp_qrcode.mecard_url+';';
		if(yp_qrcode.mecard_note!='') yp_qrcode.ch += 'NOTE:'+yp_qrcode.mecard_note+';';
		yp_qrcode.ch += ';';
	}
	
	else if(yp_qrcode.type=='vcard') {
		yp_qrcode.ch = 'BEGIN:VCARD'+encodeURIComponent('\n');
		yp_qrcode.ch += 'VERSION:2.1'+encodeURIComponent('\n');
		yp_qrcode.ch += 'N:'+yp_qrcode.vcard_lname+';'+yp_qrcode.vcard_fname+encodeURIComponent('\n');
		yp_qrcode.ch += 'FN:'+yp_qrcode.vcard_fname+encodeURIComponent(' ')+yp_qrcode.vcard_lname+encodeURIComponent('\n');
		yp_qrcode.ch += 'ORG:'+yp_qrcode.vcard_org+encodeURIComponent('\n');
		yp_qrcode.ch += 'TITLE:'+yp_qrcode.vcard_title+encodeURIComponent('\n');
		yp_qrcode.ch += 'ADR:;;'+yp_qrcode.vcard_street+';'+yp_qrcode.vcard_city+';'+yp_qrcode.vcard_state+';'+yp_qrcode.vcard_zip+';'+yp_qrcode.vcard_country+encodeURIComponent('\n');
		yp_qrcode.ch += 'TEL;WORK;VOICE:'+yp_qrcode.vcard_tel+encodeURIComponent('\n');
		yp_qrcode.ch += 'EMAIL;PREF;INTERNET:'+yp_qrcode.vcard_email+encodeURIComponent('\n');
		yp_qrcode.ch += 'URL:'+yp_qrcode.vcard_url+encodeURIComponent('\n');
		yp_qrcode.ch += 'NOTE:'+yp_qrcode.vcard_note+encodeURIComponent('\n');
		yp_qrcode.ch += 'END:VCARD';
	}
	
	else if(yp_qrcode.type=='sms') {
		yp_qrcode.ch = 'SMSTO:'+yp_qrcode.sms_tel+':'+yp_qrcode.sms_message;
	}
	
	else if(yp_qrcode.type=='geo') {
		
		if(yp_qrcode.geo_lat==''&&yp_qrcode.geo_lng=='') {
			if(yp_qrcode.geo_address!='') {
				var geocoder = new google.maps.Geocoder();
				geocoder.geocode( {'address': yp_qrcode.geo_address}, function(results, status) {
				  if (status == google.maps.GeocoderStatus.OK) {
				  	var latLng = String(results[0].geometry.location);
				  	latLng = latLng.substr(1);
				  	var pos = strpos(latLng, ',');
				  	var lat = latLng.substr(0,pos);
				  	var pos2 = strpos(latLng, ')');
				  	latLng = latLng.substr(0,pos2);
				  	var lng = latLng.substr((pos+2));
				  	
				  	$('#qrcode_geo_lat').val(lat);
				  	$('#qrcode_geo_lng').val(lng);
				  	yp_qrcode.ch = 'geo:'+lat+','+lng;
				  	generate_qrcode();
				  }
				  else {
				  	alert('Please enter a valid address');
				  }
				});
			}
		}
		else {
			yp_qrcode.ch = 'geo:'+yp_qrcode.geo_lat+','+yp_qrcode.geo_lng;
			generate_qrcode();
		}
	}
	
	else if(yp_qrcode.type=='bookmark') {
		yp_qrcode.ch = 'MEBKM:TITLE:'+yp_qrcode.bkm_title+';URL:'+yp_qrcode.bkm_url+''; //;;
	}
	
	else if(yp_qrcode.type=='wifi') {
		yp_qrcode.ch = 'WIFI:S:'+yp_qrcode.wifi_ssid+';T:'+yp_qrcode.wifi_type+';P:'+yp_qrcode.wifi_password+';;';
	}
	
	else if(yp_qrcode.type=='text') {
		yp_qrcode.ch = yp_qrcode.text;
	}
}

function generate_qrcode() {
	var url = 'http://chart.apis.google.com/chart?cht=qr&chs='+yp_qrcode.qrcode_width+'x'+yp_qrcode.qrcode_height+'&chl='+yp_qrcode.ch+'&choe='+yp_qrcode.qrcode_encoding+'&chld='+yp_qrcode.qrcode_correction;
	var img = '<img src="'+url+'">';
	var url_box = 'Url: <input type="text" style="width:100%;" value="'+url+'">';
	var download_box = 'Download: <a href="./download.php?url='+encodeURIComponent(url)+'">Download image</a>';
	$('#qrcode_preview').html(img);
	$('#url_box').html(url_box);
	$('#download_box').html(download_box);
	display_shorten_url(url);
}

function strpos(haystack, needle, offset) {
    var i = (haystack + '').indexOf(needle, (offset || 0));
    return i === -1 ? false : i;
}

function display_shorten_url(url) {
	$.ajax({
		type: 'POST',
		url: './listeners/shorten_url.php',
		data: 'url='+encodeURIComponent(url),
		success: function(msg) {
			var short_url_box = 'Short url: <input type="text" style="width:100%;" value="'+msg+'">';
			$('#short_url_box').html(short_url_box);
			display_sharing_box(msg);
		}
	});
}

function display_sharing_box(url) {
	var sharing_box = 'Share:<br><a href="'+url+'" class="share" title="Facebook"><img src="./include/graph/social/16/facebook.png"></a> <a href="'+url+'" class="share" title="Twitter"><img src="./include/graph/social/16/twitter.png"></a> <a href="'+url+'" class="share" title="Google"><img src="./include/graph/social/16/google.png"></a> <a href="'+url+'" class="share" title="Delicious"><img src="./include/graph/social/16/delicious.png"></a> <a href="'+url+'" class="share" title="Digg"><img src="./include/graph/social/16/digg.png"></a> <a href="'+url+'" class="share" title="Tumblr"><img src="./include/graph/social/16/tumblr.png"></a> <a href="'+url+'" class="share" title="Yahoo"><img src="./include/graph/social/16/yahoo.png"></a>';
	$('#sharing_box').html(sharing_box);
}

$('.share').live('click', function(event) {
	event.preventDefault();
  	
	var url=$(this).attr('href');
	var title = $(this).attr('title').toLowerCase();
	
	var h = new Object();
	h.digg = "http://digg.com/submit?phase=2&url={URL}&title={TITLE}";
	h.linkedin = "http://www.linkedin.com/shareArticle?mini=true&url={URL}&title={TITLE}&summary={DESCRIPTION}&source=";
	h.technorati = "http://www.technorati.com/faves?add={URL}";
	h.delicious = "http://del.icio.us/post?url={URL}&title={TITLE}";
	h.yahoo = "http://myweb2.search.yahoo.com/myresults/bookmarklet?u={URL}&t={TITLE}";
	h.google = "http://www.google.com/bookmarks/mark?op=edit&bkmk={URL}&title={TITLE}";
	h.newsvine = "http://www.newsvine.com/_wine/save?u={URL}&h={TITLE}";
	h.reddit = "http://reddit.com/submit?url={URL}&title={TITLE}";
	h.live = "https://favorites.live.com/quickadd.aspx?marklet=1&mkt=en-us&url={URL}&title={TITLE}&top=1";
	h.facebook = "http://www.facebook.com/share.php?u={URL}";
	h.twitter = "http://twitter.com/?status={TITLE}{URL}";
	h.stumbleupon = "http://www.stumbleupon.com/submit?url={URL}&title={TITLE}";
	h.orkut = "http://promote.orkut.com/preview?nt=orkut.com&tt={TITLE}&du={URL}&cn={DESCRIPTION}";
	h.bebo = "http://www.bebo.com/c/share?Url={URL}&title={TITLE}";
	h.evernote = "http://s.evernote.com/grclip?url={URL}&title={TITLE}";
	h.mixx = "http://www.mixx.com/submit?page_url={URL}&title={TITLE}";
	h.myspace = "http://www.myspace.com/Modules/PostTo/Pages/?u={URL}&title={TITLE}";
	h.netvibes = "http://www.netvibes.com/share?title={TITLE}&url={URL}";
	h.tumblr = "http://www.tumblr.com/share?v=3&u={URL}&t={TITLE}&s=";
	h.google_buzz = "http://www.google.com/reader/link?url={URL}&title={TITLE}&srcURL={URL}";
	h.friendfeed = "http://friendfeed.com/share/bookmarklet/frame#title={TITLE}&url={URL}";
	h.design_moo = "http://www.designmoo.com/node/add/drigg/?url={URL}&title={TITLE}";
	h.designfloat = "http://www.designfloat.com/submit.php?url={URL}&title={TITLE}";
	h.design_bump = "http://www.designbump.com/node/add/drigg/?url={URL}&title={TITLE}";
	h.squidoo = "http://www.squidoo.com/lensmaster/bookmark?{URL}";
	h.yahoo_buzz = "http://buzz.yahoo.com/buzz?targetUrl={URL}&headline={TITLE}&summary={DESCRIPTION}";
	h.print = 'javascript:void(0);" onClick="print_page();" target="_self';
	h.favorites = 'javascript:void(0);" onClick="bookmark_us();" target="_self';
	
	u = h[title];
	
	title='';
	
	u = u.replace("{TITLE}", encodeURIComponent(title));
	u = u.replace("{URL}", encodeURIComponent(url));
	u = u.replace("{KEYWORDS}", encodeURIComponent(''));
	u = u.replace("{DESCRIPTION}", encodeURIComponent(''));
	
  	var width = '800';
  	var height = '500';
	window.open(u, "", "scrollbars=yes,menubar=no,toolbar=no,resizable=yes,width="
    + width + ",height=" + height + ",left=" +
	((screen.width - 760)/2) + ",top=" + ((screen.height - 450)/2) );
	
});

$('#qrcode_text').live('keydown keyup', function(event) {
	updateTextCounter(420,'qrcode_text','nb_char');
});

function updateTextCounter(maxlimit,domStatus,domStatusCount) {
	var nb = $('#'+domStatus).val().length;
	if(nb>0) {
		$('#'+domStatusCount).html('Number of characters: '+nb);
	}
	else {
		$('#'+domStatusCount).html('');
	}
}