<?php

function irpp_ui_feedback() {
    global $irpp;

    $irpp->Form->prefix='Feedback';
    if($irpp->Check->nonce('irpp_feedback', 'irpp_feedback')) {
        $irpp->Check->email('email');
        $irpp->Check->value('body');

        if(!$irpp->Check->hasErrors()) {
            $irpp->Options->setFeedbackEmail($irpp->Check->of('email'));
            $id=-1;
            if($irpp->Check->of('track', 0)) {
                $id=$irpp->Tracking->sendTracking(TRUE);
            }
            $irpp->Check->data['tracking_id']=$id;
            $irpp->Check->data['plugin']=IRPP_PLUGIN_SLUG;
            $data=$irpp->Utils->remotePost('feedback', $irpp->Check->data);
            if($data) {
                $irpp->Options->pushSuccessMessage('FeedbackSuccess');
            } else {
                $irpp->Options->pushErrorMessage('FeedbackError');
            }
        }
    }
    ?>
    <br>
    <h2><?php $irpp->Lang->P('FeedbackHeader')?></h2>
    <?php
    $irpp->Options->writeMessages();

    $irpp->Form->formStarts();
    $irpp->Form->text('email', $irpp->Options->getFeedbackEmail());
    $irpp->Form->textarea('body', '', array('rows'=>5));

    $irpp->Form->leftLabels=FALSE;
    $irpp->Form->checkbox('track');
    $irpp->Form->leftLabels=TRUE;

    $irpp->Form->nonce('irpp_feedback', 'irpp_feedback');
    $irpp->Form->submit('Send');
    $irpp->Form->formEnds();
}