<?php
/*

Copyright 2017 MagicToolbox (email : support@magictoolbox.com)

*/

$error_message = false;
$update_plugin = true;

function WordPress_MagicZoomPlus_activate () {

    set_transient( 'WordPress_MagicZoomPlus_welcome_license_activation_redirect', true, 30 );

    if(!function_exists('file_put_contents')) {
        function file_put_contents($filename, $data) {
            $fp = fopen($filename, 'w+');
            if ($fp) {
                fwrite($fp, $data);
                fclose($fp);
            }
        }
    }

    /* === onlyForMod start: woocommerce */

    //fix url's in css files
    $fileContents = file_get_contents(dirname(__FILE__) . '/core/magiczoomplus.css');
    $cssPath = preg_replace('/https?:\/\/[^\/]*/is', '', get_option("siteurl"));

    $cssPath .= '/wp-content/'.preg_replace('/^.*?\/(plugins\/.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__))).'/core';

    $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
    $replace = 'url($1'.$cssPath.'/$2$1)';

    $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
    if($fixedFileContents != $fileContents) {
        file_put_contents(dirname(__FILE__) . '/core/magiczoomplus.css', $fixedFileContents);
    }

    magictoolbox_WordPress_MagicZoomPlus_create_teble();
    magictoolbox_WordPress_MagicZoomPlus_create_db();

    magictoolbox_WordPress_MagicZoomPlus_init();

    WordPress_MagicZoomPlus_send_stat('install');
}

function WordPress_MagicZoomPlus_deactivate () {}

function WordPress_MagicZoomPlus_uninstall() {
    magictoolbox_WordPress_MagicZoomPlus_remove_teble();

    magictoolbox_WordPress_MagicZoomPlus_delete_row_from_db();

    if (magictoolbox_WordPress_MagicZoomPlus_is_empty_db() && !count(WordPress_MagicZoomPlus_get_active_modules())) {
        magictoolbox_WordPress_MagicZoomPlus_remove_db();
    }

    delete_option("WordPressMagicZoomPlusCoreSettings");
    WordPress_MagicZoomPlus_send_stat('uninstall');
}

function WordPress_MagicZoomPlus_get_active_modules() {
    $name = explode('/', plugin_basename( __FILE__ ));
    $name = $name[0];
    $mtb_ap = array();

    foreach (get_option('active_plugins') as $value) {
        $name2 = explode('/', $value);
        $name2 = $name2[0];

        if ($name2 != $name && preg_match('/magiczoom|magiczoomplus|magic360|magicslideshow|magicscroll|magicthumb/', $value)) {
            $mtb_ap[] = $value;
        }
    }

    return $mtb_ap;
}

function WordPress_MagicZoomPlus_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v6.8.24' || 'working' == 'v5.3.5') {
        return;
    }

    $hostname = 'www.magictoolbox.com';

    $url = preg_replace('/^https?:\/\//is', '', get_option("siteurl"));
    $url = urlencode(urldecode($url));

    global $wp_version;
    $platformVersion = isset($wp_version) ? $wp_version : '';

    $path = "api/stat/?action={$action}&tool_name=magiczoomplus&license=trial&tool_version=v5.3.5&module_version=v6.8.24&platform_name=wordpress&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}





function showMessage_WordPress_MagicZoomPlus($message, $errormsg = false) {
    if ($errormsg) {
        echo '<div id="message" class="error">';
    } else {
        echo '<div id="message" class="updated fade">';
    }
    echo "<p><strong>$message</strong></p></div>";
}


function showAdminMessages_WordPress_MagicZoomPlus(){
    global $error_message;
    if (current_user_can('edit_posts')) {
       showMessage_WordPress_MagicZoomPlus($error_message,true);
    }
}


function plugin_get_version_WordPress_MagicZoomPlus() {
    $plugin_data = get_plugin_data(dirname(plugin_dir_path(__FILE__)).'/mod_wordpress_magiczoomplus.php');
    $plugin_version = $plugin_data['Version'];
    return $plugin_version;
}

function update_plugin_message_WordPress_MagicZoomPlus() {
    $ver = json_decode(@file_get_contents('http://www.magictoolbox.com/api/platform/wordpress/version/'));
    if (empty($ver)) return false;
    $ver = str_replace('v','',$ver->version);
    $oldVer = plugin_get_version_WordPress_MagicZoomPlus();
    if (version_compare($oldVer, $ver, '<')) {
        echo '<div id="message" class="updated fade">
                  <p>New version available! We recommend that you download the <a href="'.WordPressMagicZoomPlus_url('http://magictoolbox.com/magiczoomplus/modules/wordpress/',' plugins page update link ').'">latest version</a> of Magic Zoom Plus for WordPress . </p>
              </div>';
    }
}

function get_tool_version_WordPress_MagicZoomPlus($tool=null) {
    global $wp_filesystem;

    if (!$tool) {
        $tool = 'magiczoomplus';
    }

    WP_Filesystem();

    if (empty($wp_filesystem)) {
        require_once (ABSPATH . '/wp-admin/includes/file.php');
        WP_Filesystem();
    }

    $r = $wp_filesystem->get_contents(plugin_dir_path( __FILE__ ).'core/'.$tool.'.js');

    if (!preg_match('/demo/is',$r)) {
        $version = 'commercial';
    } else {
        $version = 'trial';
    }
    return $version;
}

function MagicZoomPlus_remove_update_nag($value) {
    if (isset($value->response)) {
        unset($value->response[ str_replace('/plugin','',plugin_basename(__FILE__)) ]);
    }
    return $value;
}

function  magictoolbox_WordPress_MagicZoomPlus_init() {

    add_action( 'admin_init', 'WordPressMagicZoomPlus_welcome_license_do_redirect' );

    global $error_message;

    require_once(dirname(__FILE__) . '/constructor_magiczoomplus/wordpress_magiczoomplus_fns.php');
    require_once(dirname(__FILE__) . '/constructor_magiczoomplus/wordpress_magiczoomplus_tool_db.php');
    require_once(dirname(__FILE__) . '/widget/widget_wordpress_magiczoomplus.php');
    require_once(dirname(__FILE__) . '/core/visual_composer/vc_wordpress_magiczoomplus.php');

    add_action("admin_menu", "magictoolbox_WordPress_MagicZoomPlus_config_page_menu");
    add_action('admin_enqueue_scripts', 'WordPress_MagicZoomPlus_load_admin_scripts');
    add_action('wp_enqueue_scripts', 'WordPress_MagicZoomPlus_load_frontend_scripts');

    //add_filter('filesystem_method', create_function('$a', 'return "direct";' ));
    add_filter('filesystem_method', function($a) { return "direct"; });

    add_filter("the_content", "magictoolbox_WordPress_MagicZoomPlus_create", 13);

    require_once(dirname(__FILE__)."/core/autoupdate.php");
    require_once(dirname(__FILE__)."/core/view/import_export/export.php");
    add_action('wp_ajax_WordPress_MagicZoomPlus_import', 'WordPress_MagicZoomPlus_import');
    add_action('wp_ajax_WordPress_MagicZoomPlus_export', 'WordPress_MagicZoomPlus_export');

    add_action('wp_ajax_WordPress_MagicZoomPlus_save', 'magictoolbox_ajax_WordPress_MagicZoomPlus_save');
    add_action('wp_ajax_WordPress_MagicZoomPlus_check_shortcode', 'magictoolbox_ajax_WordPress_MagicZoomPlus_check_shortcode');
    add_action('wp_ajax_WordPress_MagicZoomPlus_remove_tools', 'magictoolbox_ajax_WordPress_MagicZoomPlus_remove_tools');
    add_action('wp_ajax_WordPress_MagicZoomPlus_copy_tool', 'magictoolbox_ajax_WordPress_MagicZoomPlus_copy');
    add_action('wp_ajax_WordPress_MagicZoomPlus_get_img_urls', 'magictoolbox_ajax_WordPress_MagicZoomPlus_get_img_urls');
    add_action('wp_ajax_WordPress_MagicZoomPlus_activate_magicscroll', 'magictoolbox_ajax_WordPress_MagicZoomPlus_activate_magicscroll');
    add_action('admin_head', 'magictoolbox_WordPress_MagicZoomPlus_add_my_tc_button');
    add_action('wp_ajax_WordPress_MagicZoomPlus_tiny_mce_data', 'magictoolbox_WordPress_MagicZoomPlus_get_tiny_mce_data');
    add_shortcode('magiczoomplus', 'magictoolbox_WordPress_MagicZoomPlus_shortcode');

    add_action('wp_ajax_magictoolbox_WordPress_MagicZoomPlus_set_license', 'magictoolbox_WordPress_MagicZoomPlus_set_license');



    
    
    add_filter('site_transient_update_plugins', 'MagicZoomPlus_remove_update_nag');
    
    add_filter( 'plugin_action_links', 'magictoolbox_WordPress_MagicZoomPlus_links', 10, 2 );
    add_filter( 'plugin_row_meta', 'magictoolbox_WordPress_MagicZoomPlus_plugin_row_meta' , 10, 2 );

    if (!file_exists(dirname(__FILE__) . '/core/magiczoomplus.js')) {
        $jsContents = file_get_contents('http://www.magictoolbox.com/static/magiczoomplus/trial/magiczoomplus.js');
        if (!empty($jsContents) && preg_match('/\/\*.*?\\\*/is',$jsContents)){
            if ( !is_writable(dirname(__FILE__) . '/core/')) {
                $error_message = 'The '.substr(dirname(__FILE__),strpos(dirname(__FILE__),'wp-content')).'/core/magiczoomplus.js file is missing. Please re-uplaod it.';
            }
            file_put_contents(dirname(__FILE__) . '/core/magiczoomplus.js', $jsContents);
            chmod(dirname(__FILE__) . '/core/magiczoomplus.js', 0777);
        } else {
            $error_message = 'The '.substr(dirname(__FILE__),strpos(dirname(__FILE__),'wp-content')).'/core/magiczoomplus.js file is missing. Please re-uplaod it.';
        }
    }
    if ($error_message) add_action('admin_notices', 'showAdminMessages_WordPress_MagicZoomPlus');

    if(!isset($GLOBALS['magictoolbox']['WordPressMagicZoomPlus'])) {
        require_once(dirname(__FILE__) . '/core/magiczoomplus.module.core.class.php');
        $coreClassName = "MagicZoomPlusModuleCoreClass";
        $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'] = new $coreClassName;
        $coreClass = &$GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];
    }
    $coreClass = &$GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];
    /* get current settings from db */
    $settings = get_option("WordPressMagicZoomPlusCoreSettings");
    if($settings !== false && is_array($settings) && isset($settings['default']) && !isset($_GET['reset_settings'])) {
        foreach (WordPressMagicZoomPlus_getParamsProfiles() as $profile => $name) {
        if (isset($settings[$profile])) {
        $coreClass->params->appendParams($settings[$profile],$profile);
        }
    }
    } else { //set defaults
        $allParams = array();
        $defaults = $coreClass->params->getParams('default');
        $map = WordPressMagicZoomPlus_getParamsMap();

    foreach (WordPressMagicZoomPlus_getParamsProfiles() as $profile => $name) {
        $params = array();
        foreach ($defaults as $id => $param) {;
                if (isset($map[$profile][$param['group']]) && is_array($map[$profile][$param['group']]) && in_array($id,$map[$profile][$param['group']])) { //set defaults only according to mapping
                    $params[$id] = $param;
                }
            }
            $coreClass->params->setParams($params,$profile);

        $allParams[$profile] = $coreClass->params->getParams($profile);
    }

    delete_option("WordPressMagicZoomPlusCoreSettings");
        add_option("WordPressMagicZoomPlusCoreSettings", $allParams);
    }

    add_action( 'upgrader_process_complete', 'WordPress_MagicZoomPlus_get_packed_js', 10, 2 );
    
}

function WordPress_MagicZoomPlus_init_wp_filesystem($form_url) {
    global $wp_filesystem;
    $creds = request_filesystem_credentials($form_url, '', false, plugin_dir_path( __FILE__ ), false);

    if (!WP_Filesystem($creds)) {
        request_filesystem_credentials($form_url, '', true, plugin_dir_path( __FILE__ ), false);
        return false;
    }
    return true;
}

function WordPress_MagicZoomPlus_write_file ($url, $content) {
    global $wp_filesystem;
    // if (empty($wp_filesystem)) {
    //     require_once (ABSPATH . '/wp-admin/includes/file.php');
    // }
    WordPress_MagicZoomPlus_init_wp_filesystem($url);

    $result = $wp_filesystem->put_contents($url, $content, FS_CHMOD_FILE );

    return $result ? null : "Failed to write to file";
}

function WordPress_MagicZoomPlus_rewrite ($option, $tool) {
    $response = get_option($option);
    $result = WordPress_MagicZoomPlus_write_file(plugin_dir_path(__FILE__).'core/'.$tool.'.js', $response);
    return $result;
}

function WordPress_MagicZoomPlus_get_packed_js ($upgrader_object, $options) {
    if ('update' == $options['action'] && 'plugin' == $options['type']) {
        foreach ($options['plugins'] as $pl) {
            $_plugin = explode("/", $pl);
            $_plugin = $_plugin[count($_plugin) - 1];
            if ('mod_wordpress_magiczoomplus.php' === $_plugin) {
                $key = magictoolbox_WordPress_MagicZoomPlus_get_data_from_db();
                if (!$key) {
                    $result = WordPress_MagicZoomPlus_rewrite("WordPress_MagicZoomPlus_backup", 'magiczoomplus');
                }
                break;
            }
        }
    }
}

function WordPress_MagicZoomPlus_load_frontend_scripts () {
    $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];

    $tool_lower = 'magiczoomplus';
    switch ($tool_lower) {
        case 'magicthumb':      $priority = '10'; break;
        case 'magic360':        $priority = '11'; break;
        case 'magiczoom':       $priority = '12'; break;
        case 'magiczoomplus':   $priority = '13'; break;
        case 'magicscroll':     $priority = '14'; break;
        case 'magicslideshow':  $priority = '15'; break;
        default :               $priority = '11'; break;
    }

    wp_register_style( 'magictoolbox_magiczoomplus_style', plugin_dir_url( __FILE__ ).'core/magiczoomplus.css', array(), false, 'all');
    wp_register_style( 'magictoolbox_magiczoomplus_module_style', plugin_dir_url( __FILE__ ).'core/magiczoomplus.module.css', array(), false, 'all');
    wp_register_script( 'magictoolbox_magiczoomplus_script', plugin_dir_url( __FILE__ ).'core/magiczoomplus.js', array(), false, true);
    wp_register_style( 'magictoolbox_magiczoomplus_gallery_style', plugin_dir_url( __FILE__ ).'gallery/wordpress_magiczoomplus_gallery.css', array('magictoolbox_magiczoomplus_module_style'), false, 'all');
    wp_register_script( 'magictoolbox_magiczoomplus_gallery_script', plugin_dir_url( __FILE__ ).'gallery/wordpress_magiczoomplus_gallery.js', array( 'jquery' ), false, true);
    wp_register_style( 'magictoolbox_gallery_shortcode_style', plugin_dir_url( __FILE__ ).'core/magicgallery.css', array('magictoolbox_magiczoomplus_module_style'), false, 'all');
    wp_register_script( 'magictoolbox_gallery_shortcode_script', plugin_dir_url( __FILE__ ).'core/magicgallery.js', array( 'jquery' ), false, true);
    add_action("wp_footer", "magictoolbox_WordPress_MagicZoomPlus_add_src_to_footer", $priority);
    add_action("wp_footer", "magictoolbox_WordPress_MagicZoomPlus_add_options_script", 10001);
}

function WordPress_MagicZoomPlus_load_admin_scripts () {
    wp_enqueue_script( 'jquery' ,includes_url('/js/jquery/jquery.js'));
    wp_enqueue_script( 'jquery-ui-core', includes_url('/js/jquery/ui/core.js') );
    wp_enqueue_script( 'jquery-ui-tabs', includes_url('/js/jquery/ui/tabs.js') );

    $ownPage = false;
    if (array_key_exists('page', $_GET)) {
        $ownPage =  "WordPressMagicZoomPlus-config-page" ==  $_GET["page"]        ||
                    "WordPressMagicZoomPlus-shortcodes-page" ==  $_GET["page"]    ||
                    "WordPressMagicZoomPlus-import-export-page" ==  $_GET["page"] ||
                    "WordPressMagicZoomPlus-license-page" ==  $_GET["page"];
    }

    if (is_admin()) {
        wp_register_script( 'wordpress_MagicZoomPlus_admin_adminpage_script', plugin_dir_url( __FILE__ ).'core/wordpress_MagicZoomPlus_adminpage.js', array('jquery', 'jquery-ui-core', 'jquery-ui-tabs'), null );
        wp_enqueue_style( 'magictoolbox_wordpress_MagicZoomPlus_admin_menu_style', plugin_dir_url( __FILE__ ).'core/admin_menu.css', array(), null );
        if ($ownPage) {
            wp_enqueue_style( 'magictoolbox_wordpress_MagicZoomPlus_admin_page_style', plugin_dir_url( __FILE__ ).'core/admin.css', array(), null );
        }

        if ($ownPage) {
            wp_enqueue_style( 'WordPress_MagicZoomPlus_admin_list_style', plugin_dir_url( __FILE__ ).'constructor_magiczoomplus/css/magiczoomplus_list.css', array(), null );
            wp_enqueue_style( 'WordPress_MagicZoomPlus_admin_spinshortcodes_style', plugin_dir_url( __FILE__ ).'constructor_magiczoomplus/css/magiczoomplus_shortcodes.css', array(), null );

            if ($_GET["page"] == "WordPressMagicZoomPlus-shortcodes-page") {
                wp_enqueue_style( 'WordPress_MagicZoomPlus_admin_magiczoomplus_style', plugin_dir_url( __FILE__ ).'core/magiczoomplus.module.css', array(), null );
            }
            wp_enqueue_style( 'magictoolbox_WordPress_MagicZoomPlus_tool_style', plugin_dir_url( __FILE__ ).'core/magiczoomplus.css', array(), null );
        }
        wp_register_script( 'WordPress_MagicZoomPlus_admin_list_script', plugin_dir_url( __FILE__ ).'constructor_magiczoomplus/js/magiczoomplus_list.js', array('jquery'), null );
        wp_register_script( 'WordPress_MagicZoomPlus_admin_spinshortcodes_script', plugin_dir_url( __FILE__ ).'constructor_magiczoomplus/js/magiczoomplus_shortcodes.js', array('jquery'), null );
        $path = magictoolbox_WordPress_MagicZoomPlus_get_path_to_magicscroll();
        if ($path) {
            wp_enqueue_style( 'magictoolbox_WordPress_MagicZoomPlus_magicsroll_for_shortcode_style', $path.'magicscroll.css', array(), null );
            wp_register_script( 'magictoolbox_WordPress_MagicZoomPlus_magicsroll_for_shortcode_script', $path.'magicscroll.js', array('WordPress_MagicZoomPlus_admin_spinshortcodes_script'), null );
        }
        wp_register_script( 'magictoolbox_WordPress_MagicZoomPlus_tool_script', plugin_dir_url( __FILE__ ).'core/magiczoomplus.js', array('WordPress_MagicZoomPlus_admin_spinshortcodes_script'), null );
        add_action('admin_print_styles', 'magictoolbox_WordPress_MagicZoomPlus_button_css');
        if ($ownPage) {
            wp_enqueue_style( 'WordPress_MagicZoomPlus_admin_import_export_style', plugin_dir_url( __FILE__ ).'core/view/import_export/wordpress_MagicZoomPlus_import_export.css', array(), null );
            wp_enqueue_style( 'WordPress_MagicZoomPlus_admin_license_style', plugin_dir_url( __FILE__ ).'core/view/license/wordpress_MagicZoomPlus_license.css', array(), null );
        }
        wp_register_script( 'WordPress_MagicZoomPlus_admin_import_export_script', plugin_dir_url( __FILE__ ).'core/view/import_export/wordpress_MagicZoomPlus_import_export.js', array('jquery'), null );
        wp_register_script( 'WordPress_MagicZoomPlus_admin_license_script', plugin_dir_url( __FILE__ ).'core/view/license/wordpress_MagicZoomPlus_license.js', array('jquery'), null );
        wp_enqueue_style( 'magictoolbox_WordPress_MagicZoomPlus_gallery_style', plugin_dir_url( __FILE__ ).'gallery/wordpress_magiczoomplus_gallery.css', ($ownPage && $_GET["page"] == "WordPressMagicZoomPlus-shortcodes-page") ? array('WordPress_MagicZoomPlus_admin_magiczoomplus_style') : array(), null);
        wp_register_script( 'magictoolbox_WordPress_MagicZoomPlus_gallery_script', plugin_dir_url( __FILE__ ).'gallery/wordpress_magiczoomplus_gallery.js', array( 'jquery' ), null);
        
    }
}


/**
  * Show row meta on the plugin screen.
  *
  * @param  mixed $links Plugin Row Meta
  * @param  mixed $file  Plugin Base file
  * @return array
  */

function magictoolbox_WordPress_MagicZoomPlus_plugin_row_meta( $links, $file ) {

    if (strpos(plugin_dir_path(__FILE__),plugin_dir_path($file))) {
        $row_meta = array($links[0],$links[1]);
        $row_meta['Settings'] = '<a href="admin.php?page=WordPressMagicZoomPlus-config-page">'.__('Settings').'</a>';
        $row_meta['Support'] =  '<a target="_blank" href="'.WordPressMagicZoomPlus_url('https://www.magictoolbox.com/contact/','plugins page support link').'">Support</a>';
        $row_meta['Buy'] = '<a target="_blank" href="'.WordPressMagicZoomPlus_url('https://www.magictoolbox.com/buy/magiczoomplus/','plugins page buy link').'">Buy</a>';
        $row_meta['More cool plugins'] = '<a target="_blank" href="'.WordPressMagicZoomPlus_url('https://www.magictoolbox.com/wordpress/','plugins page more cool plugins link').'">More cool plugins</a>';

        return $row_meta;
    }

    return (array) $links;
}

function WordPressMagicZoomPlus_config_page() {
    include 'core/view/settings/wordpress_MagicZoomPlus_settings.php';
}

function WordPress_MagicZoomPlus_add_admin_src_to_menu_page() {
    wp_enqueue_script( 'wordpress_MagicZoomPlus_admin_adminpage_script' );

    $arr = array(
        'ajax'   => get_site_url().'/wp-admin/admin-ajax.php',
        'nonce'  => wp_create_nonce('magic-everywhere'),
        'mtburl' => 'https://www.magictoolbox.com/site/order/'
    );

    wp_localize_script( 'wordpress_MagicZoomPlus_admin_adminpage_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', $arr);
}

function WordPress_MagicZoomPlus_import() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $tool = 'wordpress_magiczoomplus';

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        return;
    }

    $file = $_FILES['file'];

    $arr = (array) simplexml_load_string(file_get_contents($file["tmp_name"]),'SimpleXMLElement', LIBXML_NOCDATA);

    if (array_key_exists('tool', $arr) && $tool == $arr['tool']) {
        if (array_key_exists('license', $arr) && $arr['license'] != 'trial' && strlen($arr['license']) == 7) {
            magictoolbox_WordPress_MagicZoomPlus_update_db($arr['license']);

            $url = 'https://www.magictoolbox.com/site/order/'.$arr['license'].'/magiczoomplus.js';
            $response = magictoolbox_WordPress_MagicZoomPlus_get_file($url);
            if($response['status'] == 200) {
                WordPress_MagicZoomPlus_write_file(plugin_dir_path( __FILE__ ).'core/magiczoomplus.js', $response['content']);
            }
        }
        if (array_key_exists('scrolllicense', $arr) && $arr['scrolllicense'] != 'trial' && strlen($arr['scrolllicense']) == 7) {
            magictoolbox_WordPress_MagicZoomPlus_update_db($arr['scrolllicense'], 'WordPress_MagicZoomPlus_magicscroll');
            $url = 'https://www.magictoolbox.com/site/order/'.$arr['scrolllicense'].'/magicscroll.js';
            $response = magictoolbox_WordPress_MagicZoomPlus_get_file($url);
            if($response['status'] == 200) {
                WordPress_MagicZoomPlus_write_file(plugin_dir_path( __FILE__ ).'core/magicscroll.js', $response['content']);
            }
        }

        if (array_key_exists('core', $arr)) {
            $core = (array) $arr['core'];

            $settings = get_option("WordPressMagicZoomPlusCoreSettings");

            foreach ($core as $profile => $name) {
                $name = (array) $name;
                foreach ($name as $key => $value) {
                    $value = (array) $value;
                    if ('' != $value[0]) {
                        $settings[$profile][$key]['value'] = $value[0];
                    }
                }
            }

            delete_option("WordPressMagicZoomPlusCoreSettings");
            add_option("WordPressMagicZoomPlusCoreSettings", $settings);
        }

        if (array_key_exists('constructor', $arr)) {
            $constructor = (array) $arr['constructor'];
            $constructor = (array) $constructor[$tool];

            if (empty($constructor['id'])) {
                foreach ($constructor as $value) {
                    $value = (array) $value;
                    magictoolbox_WordPress_MagicZoomPlus_add_data_to_table($value['name'], $value['shortcode'], $value['image'], $value['thumbnails'], $value['options'], $value['mobile_options'], $value['additional_options']);
                }
            } else {
                magictoolbox_WordPress_MagicZoomPlus_add_data_to_table($constructor['name'], $constructor['shortcode'], $constructor['image'], $constructor['thumbnails'], $constructor['options'], $constructor['mobile_options'], $constructor['additional_options']);
            }
        }
    }
    // exit;
}

function WordPress_MagicZoomPlus_export() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $value = $_POST['value'];
    $secret_data = null;

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        return;
    }

    if (function_exists('magictoolbox_WordPress_MagicZoomPlus_get_data')) {
        $secret_data = magictoolbox_WordPress_MagicZoomPlus_get_data();
    }

    WordPress_MagicZoomPlus_wp_export($value, get_option("WordPressMagicZoomPlusCoreSettings"), $secret_data);
    exit;
}

function magictoolbox_WordPress_MagicZoomPlus_add_src_to_footer() {
    global $magictoolbox_MagicZoomPlus_page_has_shortcode,
           $magictoolbox_MagicZoomPlus_page_has_tool,
           $magictoolbox_page_has_gallery,
           $magictoolbox_MagicZoomPlus_page_added_script,
           $magictoolbox_page_added_gallery_script,
           $magictoolbox_page_has_shortcode_gallery,
           $magictoolbox_page_added_shortcode_gallery_script;

    if (!$magictoolbox_MagicZoomPlus_page_has_tool) {
        $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];

        if ($plugin->params->checkValue('include-headers','yes') || isset($GLOBALS['custom_template_headers'])) {
            $magictoolbox_MagicZoomPlus_page_has_tool = true; // add footers for all pages
            //if (isset($GLOBALS['custom_template_headers'])) unset($GLOBALS['custom_template_headers']); //prevent render on non-product pages
            $magictoolbox_page_has_gallery = true;
        }
    }

    if (!$magictoolbox_MagicZoomPlus_page_added_script) {
        $magictoolbox_MagicZoomPlus_page_added_script = true;

        if ($magictoolbox_MagicZoomPlus_page_has_shortcode || $magictoolbox_MagicZoomPlus_page_has_tool) {
            wp_enqueue_style('magictoolbox_magiczoomplus_style');
            wp_enqueue_style('magictoolbox_magiczoomplus_module_style');
            wp_enqueue_script('magictoolbox_magiczoomplus_script');
        }


        if ($magictoolbox_MagicZoomPlus_page_has_tool) {
            // wp_enqueue_style('magictoolbox_magiczoomplus_style');
            // wp_enqueue_style('magictoolbox_magiczoomplus_module_style');
            // wp_enqueue_script('magictoolbox_magiczoomplus_script');
        }
    }

    if (!$magictoolbox_page_added_gallery_script && $magictoolbox_page_has_gallery) {
        $magictoolbox_page_added_gallery_script = true;
        wp_enqueue_style('magictoolbox_magiczoomplus_gallery_style');
        wp_enqueue_script('magictoolbox_magiczoomplus_gallery_script');
    }
    if (!$magictoolbox_page_added_shortcode_gallery_script && $magictoolbox_page_has_shortcode_gallery) {
        $magictoolbox_page_added_shortcode_gallery_script = true;
        wp_enqueue_style('magictoolbox_gallery_shortcode_style');
        wp_enqueue_script('magictoolbox_gallery_shortcode_script');
    }
}

function magictoolbox_WordPress_MagicZoomPlus_add_options_script () {
    global $magictoolbox_MagicZoomPlus_page_added_options,
            $magictoolbox_MagicZoomPlus_page_has_shortcode,
            $magictoolbox_MagicZoomPlus_page_has_tool;
    $footers = '';

    if (!$magictoolbox_MagicZoomPlus_page_added_options) {
        $magictoolbox_MagicZoomPlus_page_added_options = true;


        if ($magictoolbox_MagicZoomPlus_page_has_shortcode || $magictoolbox_MagicZoomPlus_page_has_tool) {
            $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];
            $footers = $plugin->getOptionsTemplate();

            $o = get_option("WordPressMagicZoomPlusCoreSettings");
            $o = $o['default'];
            if(isset($o['background']['value']) && '' != trim($o['background']['value'])) {
                $footers .= '<style type=\'text/css\'>';
                $footers .= '.mz-expand .mz-expand-bg { display: none !important; } .mz-expand { background-color: '.$o['background']['value'].' !important; }';
                $footers .= '</style>';
            }

            if (function_exists('plugins_url')) {
                $core_url = plugins_url();
            } else {
                $core_url = get_option("siteurl").'/wp-content/plugins';
            }
            $path = preg_replace('/^.*?\/plugins\/(.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__)));

        }
        echo $footers;
    }
}

function magictoolbox_WordPress_MagicZoomPlus_get_file($url) {
    $result = array( 'content' => '', 'status' => 0);

    if ($url && is_string($url)) {
        $url = trim($url);
        if ('' != $url) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
            $response = curl_exec($ch);
            $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $result['content'] = $response;
            $result['status'] = $code;
        }
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_set_license() {
    global $wp_filesystem;

    if (empty($wp_filesystem)) {
        require_once (ABSPATH . '/wp-admin/includes/file.php');
    }

    WP_Filesystem();
    // ob_end_clean();

    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $key = $_POST['key'];
    $extra_param = $_POST['param'];
    $result = '{"error": "error"}';

    if (!$extra_param || 'null' == $extra_param) {
        $extra_param = null;
        $tool_name = 'magiczoomplus';
    } else {
        $tool_name = $extra_param;
        $extra_param = 'WordPress_MagicZoomPlus_'.$extra_param;
    }

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = '{"error": "verification failed"}';
    } else {
        if ($key && '' != $key) {
            $url = 'https://www.magictoolbox.com/site/order/'.$key.'/'.$tool_name.'.js';
            $response = magictoolbox_WordPress_MagicZoomPlus_get_file($url);

            $code = $response['status'];
            $response = $response['content'];

            if($code == 200) {
                $result = WordPress_MagicZoomPlus_write_file(plugin_dir_path( __FILE__ ).'core/'.$tool_name.'.js', $response);
                if (!$result) {
                    magictoolbox_WordPress_MagicZoomPlus_update_db($key, $extra_param);
                    $result = 'null';
                }
                $result = '{"error": '.$result.'}';
            } else if($code == 403) {
                $result = '{"error": "limit"}';
                //Download limit reached
                //Your license has been downloaded 10 times already.
                //If you wish to download your license again, please contact us.
            } else if ($code == 404) {
                $result = '{"error": "license failed"}';
            } else {
                $result = '{"error": "Other errors"}';
            }
        }
    }
    ob_end_clean();
    echo $result;
    wp_die();
}

function magictoolbox_WordPress_MagicZoomPlus_create_db() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        $sql = "CREATE TABLE $table_name (
          id int unsigned NOT NULL auto_increment,
          name varchar(50) DEFAULT NULL,
          license varchar(50) DEFAULT NULL,
          UNIQUE KEY id (id));";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
}

function magictoolbox_WordPress_MagicZoomPlus_remove_db() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'magictoolbox_store';

    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        $wpdb->query("DROP TABLE IF EXISTS ".$table_name);
    }
}

function magictoolbox_WordPress_MagicZoomPlus_update_db($key, $name=null) {
    global $wpdb;
    $result = false;

    if (!$name || !is_string($name)) {
        $name = 'WordPress_MagicZoomPlus';
    }

    if ($key && is_string($key)) {
        $table_name = $wpdb->prefix . 'magictoolbox_store';

        $data = $wpdb->get_results("SELECT * FROM ".$table_name." WHERE name = '" . $name . "'");

        if ($data && count($data) > 0) {
            $result = $wpdb->update($table_name, array('license' => $key), array('name' => $name), array( '%s' ), array( '%s' ));
            $result = !!$result;
        } else {
            $result = $wpdb->insert($table_name, array('name' => $name, 'license' => $key));
        }
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_delete_row_from_db($name=null) {
    global $wpdb;

    if (!$name || !is_string($name)) {
        $name = 'WordPress_MagicZoomPlus';
    }

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        return $wpdb->delete( $table_name, array( 'name' => $name ) );
    } else {
        return false;
    }
}

function magictoolbox_WordPress_MagicZoomPlus_is_empty_db() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        $result = $wpdb->get_results("SELECT * FROM ".$table_name);
        return !(count($result) > 0);
    } else {
        return false;
    }
}

function magictoolbox_WordPress_MagicZoomPlus_get_data_from_db($name=null) {
    global $wpdb;
    
    if (!$name || !is_string($name)) {
        $name = 'WordPress_MagicZoomPlus';
    }
    
    if (isset($GLOBALS['WordPress_MagicZoomPlus_get_data_from_db'][$name])) {
        return $GLOBALS['WordPress_MagicZoomPlus_get_data_from_db'][$name];
    }

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    $result = $wpdb->get_results("SELECT * FROM ".$table_name." WHERE name = '".$name."'");
    
    if ($result && count($result) > 0) {
        $GLOBALS['WordPress_MagicZoomPlus_get_data_from_db'][$name] = $result[0];
        return $result[0];
    } else {
        $GLOBALS['WordPress_MagicZoomPlus_get_data_from_db'][$name] = false;
        return false;
    }
}

function magictoolbox_WordPress_MagicZoomPlus_links( $links, $file ) {
    $fileName = 'mod_wordpress_magiczoomplus_trial/mod_wordpress_magiczoomplus.php';
    
    $fileName = preg_replace('/\_trial\//', '/', $fileName);
    $fileName = preg_replace('/\_commercial\//', '/', $fileName);
    
    if ($file == $fileName) {
        $settings_link = '<a href="admin.php?page=WordPressMagicZoomPlus-config-page">'.__('Settings').'</a>';
        array_unshift( $links, $settings_link );
        $spins_link = '<a href="admin.php?page=WordPressMagicZoomPlus-shortcodes-page">Shortcodes</a>';
        array_push( $links, $spins_link );
    }
    return $links;
}

function magictoolbox_WordPress_MagicZoomPlus_config_page_menu() {
    if(function_exists("add_menu_page")) {
        //$page = add_submenu_page("admin.php", __("Magic Zoom Plus Plugin Configuration"), __("Magic Zoom Plus Configuration"), "edit_posts", "WordPressMagicZoomPlus-config-page", "WordPressMagicZoomPlus_config_page");
        $page = add_menu_page( __("Magic Zoom Plus"), __("Magic Zoom Plus"), "edit_posts", "WordPressMagicZoomPlus-config-page", "WordPressMagicZoomPlus_config_page", plugin_dir_url( __FILE__ )."core/admin_graphics/icon.svg");
        add_submenu_page( "WordPressMagicZoomPlus-config-page", 'Settings', 'Settings', 'edit_posts', "WordPressMagicZoomPlus-config-page" );
        add_action('admin_print_scripts-' . $page, 'WordPress_MagicZoomPlus_add_admin_src_to_menu_page');
    }

    if(function_exists("add_submenu_page")) {
        $submenu_page = add_submenu_page("WordPressMagicZoomPlus-config-page", "Shortcodes", "Shortcodes", "edit_posts", "WordPressMagicZoomPlus-shortcodes-page", "WordPress_MagicZoomPlus_submenu_page");
        add_action('admin_print_scripts-' . $submenu_page, 'WordPress_MagicZoomPlus_add_admin_src_to_submenu_page');

        $license_page = add_submenu_page("WordPressMagicZoomPlus-config-page", "License", "License", "edit_posts", "WordPressMagicZoomPlus-license-page", "WordPress_MagicZoomPlus_license_page");
        add_action('admin_print_scripts-' . $license_page, 'WordPress_MagicZoomPlus_add_admin_src_to_license_page');
        $import_export_page = add_submenu_page("WordPressMagicZoomPlus-config-page", "Backup / Restore", "Backup / Restore", "edit_posts", "WordPressMagicZoomPlus-import-export-page", "WordPress_MagicZoomPlus_import_export_page");
        add_action('admin_print_scripts-' . $import_export_page, 'WordPress_MagicZoomPlus_add_admin_src_to_import_export_page');

        global $submenu;
        $tmp = $submenu['WordPressMagicZoomPlus-config-page'][0];
        $submenu['WordPressMagicZoomPlus-config-page'][0] = $submenu['WordPressMagicZoomPlus-config-page'][1];
        $submenu['WordPressMagicZoomPlus-config-page'][1] = $tmp;
    }
}

function WordPress_MagicZoomPlus_submenu_page() {
    if (array_key_exists('id', $_GET)) {
        include 'constructor_magiczoomplus/view/magiczoomplus_shortcodes.php';
    } else {
        include 'constructor_magiczoomplus/view/magiczoomplus_list.php';
    }
}

function WordPress_MagicZoomPlus_add_admin_src_to_submenu_page() {
    if (array_key_exists('id', $_GET)) {
        wp_enqueue_script( 'magictoolbox_WordPress_MagicZoomPlus_tool_script' );
        wp_enqueue_script( 'WordPress_MagicZoomPlus_admin_spinshortcodes_script' );
        // wp_enqueue_script( 'magictoolbox_WordPress_MagicZoomPlus_tool_script'    );
        wp_enqueue_script( 'magictoolbox_WordPress_MagicZoomPlus_gallery_script' );
        wp_enqueue_script( 'magictoolbox_WordPress_MagicZoomPlus_magicsroll_for_shortcode_script' );
        wp_localize_script( 'WordPress_MagicZoomPlus_admin_spinshortcodes_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
        // wp_localize_script( 'WordPress_MagicZoomPlus_admin_spinshortcodes_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
        wp_enqueue_media();
    } else {
        wp_enqueue_script( 'WordPress_MagicZoomPlus_admin_list_script');
        wp_localize_script( 'WordPress_MagicZoomPlus_admin_list_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
    }
}

function WordPress_MagicZoomPlus_import_export_page() {
    include 'core/view/import_export/wordpress_MagicZoomPlus_import_export.php';
}

function WordPress_MagicZoomPlus_add_admin_src_to_import_export_page() {
    wp_enqueue_script( 'WordPress_MagicZoomPlus_admin_import_export_script' );
    wp_localize_script( 'WordPress_MagicZoomPlus_admin_import_export_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
}

function WordPress_MagicZoomPlus_license_page() {
    include 'core/view/license/wordpress_MagicZoomPlus_license.php';
}

function WordPress_MagicZoomPlus_add_admin_src_to_license_page() {
    wp_enqueue_script( 'WordPress_MagicZoomPlus_admin_license_script' );
    wp_localize_script( 'WordPress_MagicZoomPlus_admin_license_script', 'magictoolbox_WordPress_MagicZoomPlus_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
}

function magictoolbox_WordPress_MagicZoomPlus_styles() {
    if(!defined('MAGICTOOLBOX_MAGICZOOMPLUS_HEADERS_LOADED')) {
        $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];

        
        if (function_exists('plugins_url')) {
            $core_url = plugins_url();
        } else {
            $core_url = get_option("siteurl").'/wp-content/plugins';
        }


        $path = preg_replace('/^.*?\/plugins\/(.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__)));

        $headers = $plugin->getHeadersTemplate($core_url."/{$path}/core");

        echo $headers;
        define('MAGICTOOLBOX_MAGICZOOMPLUS_HEADERS_LOADED', true);
    }
}




function  magictoolbox_WordPress_MagicZoomPlus_create($content) {
    global $magictoolbox_MagicZoomPlus_page_has_tool;

    $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];


    /*set watermark options for all profiles START */
    $defaultParams = $plugin->params->getParams('default');
    $wm = array();
    $profiles = $plugin->params->getProfiles();
    foreach ($defaultParams as $id => $values) {
    if (($values['group']) == 'Watermark') {
        $wm[$id] = $values;
    }
    }
    foreach ($profiles as $profile) {
    $plugin->params->appendParams($wm,$profile);
    }
    /*set watermark options for all profiles END */

    $toolPatern = "<a\s+[^>]*class\s*=[^>]*\"MagicZoom[^>]*\"[^>]*>\s*<img[^>]*>\s*<\s*\/\s*a>";

    /*$pattern = "<img([^>]*)(?:>)(?:[^<]*<\/img>)?";
    $pattern = "(?:<a([^>]*)>.*?){$pattern}(.*?)(?:<\/a>)";*/
    $pattern = "(?:<a([^>]*)>)[^<]*<img([^>]*)(?:>)(?:[^<]*<\/img>)?(.*?)[^<]*?<\/a>";


    $oldContent = $content;


        $content = preg_replace_callback("/{$pattern}/is", "magictoolbox_WordPress_MagicZoomPlus_callback", $content);
        if ($content == $oldContent) return $content;





    /*$content = str_replace('{MAGICTOOLBOX_'.strtoupper('magiczoomplus').'_MAIN_IMAGE_SELECTOR}',$GLOBALS['MAGICTOOLBOX_'.strtoupper('magiczoomplus').'_MAIN_IMAGE_SELECTOR'],$content);  //add main image selector to other
    $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magiczoomplus').'_SELECTORS}','',$content); //if no selectors - remove constant
     onlyForModend  */

    



    if (!$magictoolbox_MagicZoomPlus_page_has_tool) {
        if (preg_match("/{$toolPatern}/is", $content)) {
            $magictoolbox_MagicZoomPlus_page_has_tool = true;
        }
    }

    return $content;
}

function magictoolbox_WordPress_MagicZoomPlus_key_sort($a, $b){
    return strnatcasecmp(basename($a['img']),basename($b['img']));
}




function  magictoolbox_WordPress_MagicZoomPlus_callback($matches) {
    $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];
    $title = "";
    $float = "";
    

    if (preg_match("/data-shortcode/", $matches[0])) {
        return $matches[0];
    }



    if (!preg_match('/(jpg|png|jpeg|gif)/is',$matches[1])) return $matches[0];

    if($plugin->params->checkValue('class', 'all')) { //apply to all images

        $tool_class = strtolower($plugin->params->getValue('class'));

        if (preg_match("/data-(zoom|thumb)-id/", $matches[0])) {
            return $matches[0];
        }

        // if(preg_match("/class\s*=\s*[\'\"]\s*(?:[^\"\'\s]*\s)*" . preg_quote('MagicZoom', '/') . "(?:\s[^\"\'\s]*)*\s*[\'\"]/iUs", $matches[0])) { //already with class.. wrap it !
        if (preg_match("/class\s*=\s*[\'\"]\s*(?:[^\"\'\s]*\s)*Magic[A-Za-z]+?(?:\s[^\"\'\s]*)*\s*[\'\"]/iUs", $matches[0])) {
            $result =  $matches[0].' ';
        } else { //need to add tool class
            if (!preg_match('/<a[^<]*?class=/is',$matches[0])) { //a tag have no class
                $result = str_replace('<a','<a class="MagicZoom"',$matches[0]);
            } else {
                $result = preg_replace('/(.*?)class=[\'\"](.*?)[\'\"](.*)/is','$1class="MagicZoom $2"$3',$matches[0]); //add tool class
            }
        }
    } else {
        if (preg_match("/class\s*=\s*[\'\"]\s*(?:[^\"\'\s]*\s)*Magic[A-Za-z]+?(?:\s[^\"\'\s]*)*\s*[\'\"]/iUs",$matches[0])) {
            $result =  $matches[0].' ';
        } else {
            return $matches[0];
        }
    }

    if (preg_match('/aligncenter|alignleft|alignright/is', $matches[0]) && preg_match("/class\s*=\s*[\'\"]\s*(?:[^\"\'\s]*\s)*" . preg_quote('MagicZoom', '/') . "(?:\s[^\"\'\s]*)*\s*[\'\"]/iUs", $result)) {
        $cl = "alignright";
        if (preg_match('/aligncenter/is', $matches[0])) {
            $cl = "aligncenter";
        } else if (preg_match('/alignleft/is', $matches[0])) {
            $cl = "alignleft";
        }
        $result = "<div class=\"MagicToolboxContainer {$cl}\">{$result}</div>";
    } else {
        $result = "<div class=\"MagicToolboxContainer\">{$result}</div>";
    }

    
    
    
    
    




    
    
    






    return $result;

}





function WordPress_MagicZoomPlus_get_post_attachments($addMain = false)  {

    $args = array(
            'post_type' => 'attachment',
            'numberposts' => '-1',
            'post_status' => null,
            'post_parent' => $post_id
        );

    $attachments = get_posts($args);
    return $attachments;
}








function WordPressMagicZoomPlus_url ($url,$position) {

    if ('commercial' == get_tool_version_WordPress_MagicZoomPlus()) {
    $utm_source = 'CommercialVerison';
    } else {
    if (magictoolbox_WordPress_MagicZoomPlus_get_data_from_db()) {
        $utm_source = 'CommercialVersion';
    } else {
        $utm_source = 'TrialVersion';
    }
    }

    $utm_medium = 'WordPress';
    $utm_content = preg_replace('/\s+/is','-',trim($position));
    $utm_campaign = 'MagicZoomPlus';

    $link = $url.'?utm_source='.$utm_source.'&utm_medium='.$utm_medium.'&utm_content='.$position.'&utm_campaign='.$utm_campaign;

    return $link;
}

function WordPressMagicZoomPlus_params_map_check ($profile = 'default', $group, $parameter) {
    $map = WordPressMagicZoomPlus_getParamsMap();
    if (isset($map[$profile][$group][$parameter])) return true;
    return false;
}
function WordPressMagicZoomPlus_getParamsMap () {
    $map = array(
		'default' => array(
			'General' => array(
				'include-headers',
				'class',
			),
			'Positioning and Geometry' => array(
				'zoomWidth',
				'zoomHeight',
				'zoomPosition',
				'zoomDistance',
			),
			'Multiple images' => array(
				'selectorTrigger',
				'transitionEffect',
			),
			'Miscellaneous' => array(
				'lazyZoom',
				'rightClick',
				'cssClass',
				'show-message',
				'message',
			),
			'Zoom mode' => array(
				'zoomMode',
				'zoomOn',
				'upscale',
				'smoothing',
				'variableZoom',
				'zoomCaption',
			),
			'Expand mode' => array(
				'expand',
				'expandZoomMode',
				'expandZoomOn',
				'expandCaption',
				'closeOnClickOutside',
				'background',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
			'Hint' => array(
				'hint',
				'textHoverZoomHint',
				'textClickZoomHint',
				'textExpandHint',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Mobile' => array(
				'zoomModeForMobile',
				'textHoverZoomHintForMobile',
				'textClickZoomHintForMobile',
				'textExpandHintForMobile',
			),
		),
	);
    return $map;
}

function WordPressMagicZoomPlus_getParamsProfiles () {

    $blocks = array(
		'default' => 'General',
	);

    return $blocks;
}

function WordPressMagicZoomPlus_welcome_license_do_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( 'WordPress_MagicZoomPlus_welcome_license_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( 'WordPress_MagicZoomPlus_welcome_license_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'WordPressMagicZoomPlus-license-page' ), admin_url( 'admin.php' ) ) );

}

function WordPressMagicZoomPlus_plugin_path() {

  return untrailingslashit( plugin_dir_path( __FILE__ ) );
 
}
 
function WordPress_MagicZoomPlus_locate_template( $template, $template_name, $template_path ) {
 
  global $woocommerce;
 
  $_template = $template;
 
  if ( ! $template_path ) $template_path = $woocommerce->template_url;
 
  $plugin_path  = WordPressMagicZoomPlus_plugin_path() . '/core/templates/';
  
  $template = locate_template(
 
    array(
 
      $template_path . $template_name,
 
      $template_name
 
    )
 
  );
    $post_id = get_the_id();

    if(function_exists('wpml_get_default_language')){
        $default_language = wpml_get_default_language();
        global $main_id;
        $main_id = icl_object_id($post_id, 'post', true, $default_language);

        if($main_id !== $post_id) $post_id = $main_id;   
    }
  
    if ( file_exists( $plugin_path . $template_name ) ) {
        $template = $plugin_path . $template_name;
    } else {
        $template = $_template;
    }
  
    if ( ! $template ) {
        $template = $_template;
    }

  return $template;
 
}

function WordPress_MagicZoomPlus_get_containers_data($thumbs = array(), $post_id = false, $useWpImages = false) {

    $mainHTML = '';
    $GLOBALS['defaultContainerId'] = 'zoom';
    $containersData = array(
        'zoom' => '',
        '360' => '',
    );
    $productImagesHTML = array();

    $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];
    
    $main_image = $GLOBALS['magictoolbox']['MagicZoomPlus']['main'];
    $main_image = preg_replace('/(<a.*?class=\".*?)\"/is', "$1" . ' lightbox-added"', $main_image);
    $containersData['zoom'] = $main_image;

    if(isset($thumbs) && !empty($thumbs)){ 
        foreach ($thumbs as $index => $thumb) {
            $thumbs[$index] = str_replace('<a ', '<a data-product-id="'.$post_id.'" data-magic-slide-id="zoom" ', $thumb);
        }
     }

    if ($useWpImages) {
        global $_wp_additional_image_sizes;
        $imageSize = $plugin->params->getValue('thumbnails-wordpress-image', 'product');
        if (in_array( $imageSize, array('thumbnail', 'medium', 'medium_large', 'large'))) {
            $sMaxWidth = (int)get_option($imageSize.'_size_w');
            $sMaxHeight = (int)get_option($imageSize.'_size_h');
        } else if (isset( $_wp_additional_image_sizes[$imageSize] ) ) {
            $sMaxWidth = (int)$_wp_additional_image_sizes[$imageSize]['width'];
            $sMaxHeight = (int)$_wp_additional_image_sizes[$imageSize]['height'];
        }
    } else {
        $sMaxWidth = (int)$plugin->params->getValue('selector-max-width', 'product');
        $sMaxHeight = (int)$plugin->params->getValue('selector-max-height', 'product');
    }

    $sizeStyle = '';
    if ((int)$sMaxHeight && (int)$sMaxWidth) {
        $sizeStyle = ' style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;" ';
    } 

    //video data
    if (metadata_exists( 'post', $post_id, '_provide_videolinks_field' )){
        $scrollEnabled = $plugin->params->checkValue('magicscroll', 'Yes');
        $productVideos = get_post_meta( $post_id, '_provide_videolinks_field', true );
        
        if (!empty($productVideos) && preg_match('/a\:\d+/is',$productVideos)) {
        
            $productVideos = unserialize($productVideos);
            $videoIndex = 1;
         
            foreach ($productVideos as $videoUrl => $videoData) {
                if($videoData['youtube']) {
                    $dataVideoType = 'youtube';
                    $url = 'https://www.youtube.com/embed/'.$videoData['code'];
                    $containersData['video-'.$videoIndex] = '<iframe src="https://www.youtube.com/embed/'.$videoData['code'].'?enablejsapi=1"';
                } else {
                    $dataVideoType = 'vimeo';
                    $url = 'https://player.vimeo.com/video/'.$videoData['code'];
                    $containersData['video-'.$videoIndex] = '<iframe src="https://player.vimeo.com/video/'.$videoData['code'].'?byline=0&portrait=0"';
                }
                
                $containersData['video-'.$videoIndex] .=' frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen data-product-id="'.$post_id.'" data-video-type="'.$dataVideoType.'"></iframe>';
                
                $videoData['thumb'] = str_replace('http://', 'https://', $videoData['thumb']);
                
                $productImagesHTML[] =
                    '<a data-magic-slide-id="video-'.$videoIndex.'" data-product-id="'.$post_id.'" data-video-type="'.$dataVideoType.'" class="video-selector" href="#" onclick="return false">'.
                    '<span><b></b></span>'.
                    '<img src="'.$videoData['thumb'].'" alt="video"'.($scrollEnabled ? '' : ' style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;"').'/>'.
                    '</a>';
                $videoIndex++;
            }
            
        }
    }

    if (metadata_exists( 'post', $post_id, '_magic360_data' ) && magictoolbox_WordPress_MagicZoomPlus_check_plugin_active('magic360') ){

        $magic360_plugin = $GLOBALS['magictoolbox']['WooCommerceMagic360'];
        $magic360_plugin->params->setProfile('product');

        if(!empty($magic360_plugin) && $magic360_plugin->params->checkValue('page-status','Yes') ){

            $magic360_data = json_decode((get_post_meta( $post_id, '_magic360_data', true )), true);
            $magic360_image_gallery = Array();
            if(!empty($magic360_data) && array_key_exists('images_ids', $magic360_data)) $magic360_image_gallery = $magic360_data['images_ids'];

            if(!empty($magic360_image_gallery)){

                $watermark = $plugin->params->getValue('watermark');
                $plugin->params->setValue('watermark', '');

                $magic360_selector_path = $magic360_plugin->params->getValue('selector-path');
                
                if (!$useWpImages) {
                    $magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img src="'.WordPress_MagicZoomPlus_get_product_image(ltrim($magic360_selector_path,'/'),'selector').'" alt="360" /></a>';
                } else {
                    //$magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;" src="'.get_site_url().$magic360_selector_path.'" alt="360" /></a>';
                    $magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img '.$sizeStyle.' src="'.get_site_url().'/'.ltrim($magic360_selector_path,'/').'" alt="360" /></a>';
                }     
                
                $plugin->params->setValue('watermark', $watermark);
                array_unshift($thumbs, $magic360_selector);

                foreach($magic360_image_gallery as $i => $image_id) {
                    $image_src = wp_get_attachment_image_src($image_id, 'original', $image_id);
                    $image_src = preg_replace('/.*(\/wp-content.*)/','$1', $image_src[0]);
                    $GLOBALS['magic360images'][$i] = array(
                        'medium' => WooCommerce_Magic360_get_product_image($image_src,'thumb', $image_id),
                        'img' => WooCommerce_Magic360_get_product_image($image_src,'original', $image_id)
                    );
                }

                $magic360_plugin->params->setValue('columns', $magic360_data['options']['columns']);

                usort($GLOBALS['magic360images'], 'magictoolbox_WordPress_MagicZoomPlus_key_sort');

                $containersData['360'] = $magic360_plugin->getMainTemplate($GLOBALS['magic360images']);
                
                $defaultView = $magic360_plugin->params->getValue('default-spin-view');
                if ($defaultView == 'Spin') {
                    $GLOBALS['defaultContainerId'] = '360';
                } else {
                    $GLOBALS['defaultContainerId'] = 'zoom';
                }

                global $magictoolbox_Magic360_page_has_tool;
                $magictoolbox_Magic360_page_has_tool = true;
                unset($GLOBALS['magic360images']);
            }
        }

    }
    
    return array('containersData'       => $containersData,
                 'productImagesHTML'    => $productImagesHTML,
                 'thumbs'               => $thumbs);
    
}


if( function_exists('register_block_type' ) ){
  if( !function_exists('WordPress_MagicZoomPlus_addmedia_block')){
    function WordPress_MagicZoomPlus_addmedia_block(){

      wp_register_script(
        'wordpress-magiczoomplus-addmedia-block-editor-js',
        plugins_url('/gutenberg/addmedia-block/editor-script.js', __FILE__),
        array( 'wp-blocks', 'wp-element', 'wp-editor', 'jquery'), NULL
      );

      register_block_type( 'wordpress-magiczoomplus/addmedia-block', array(
          'editor_script' => 'wordpress-magiczoomplus-addmedia-block-editor-js',
      ) );
    }

    add_action( 'init', 'WordPress_MagicZoomPlus_addmedia_block' );
  }

}

function WordPress_MagicZoomPlus_slideshow_gallery($atts){

    global $wpdb;

    $table_name = strtolower($wpdb->prefix . 'MagicZoomPlus_store');
    $result = $wpdb->get_results("SELECT id,name FROM $table_name ");

    return rest_ensure_response( $result );
}

add_action( 'rest_api_init', 'WordPress_MagicZoomPlus_gallery_route');

function WordPress_MagicZoomPlus_gallery_route() {
            
    register_rest_route( 'MagicZoomPlus', 'get-shortcodes', array(
            'methods' => 'GET',
            'callback' => 'WordPress_MagicZoomPlus_slideshow_gallery',
            /*'permission_callback' => function() {
                return current_user_can( 'edit_posts' );
                }, */
    ));
}
if ( !shortcode_exists( 'magicgallery' ) ) {
    add_shortcode( 'magicgallery', function( $atts, $content = null ) {
        
        global $magictoolbox_page_has_shortcode_gallery;

        $spin = '';
        
        $content = '';
        $spin_id = false;
        $tool = false;
        $tool_id = false;

        $tools = array_filter(shortcode_atts( 
            array('magiczoom' => '', 'magiczoomplus' => '', 'magicthumb' => '', 'magic360' => '')
        , $atts));
        $spinPresent = array_key_exists('magic360', $tools);

        if (count($tools) == 2 && $spinPresent) {
            $spin_id = $tools['magic360'];
            unset($tools['magic360']);
            //$tool = array_key_first($tools);
            $tool = array_shift(array_keys($tools));
            $tool_id = array_shift($tools);
        } else {
            if (count($tools) != 2) {
                $content .= 'There should be two attributes in magicgallery shortcode!</br></br>';
            }
            if (!$spinPresent) {
                $content .= 'There should be magic360 attribute in magicgallery shortcode!</br></br>';   
            }

        }

        if ($spin_id && $tool && $tool_id) {

            $spinShortcode = '[magic360 id="'.(int)$spin_id.'"]';
            $toolShortcode = '['.$tool.' id="'.(int)$tool_id.'"]';

            $spin = do_shortcode( $spinShortcode, false );
            $content = do_shortcode( $toolShortcode, false );

            $toolDone = $spinDone = true;

            if ($spin == $spinShortcode) $spinDone = false;
            if ($content == $toolShortcode) $toolDone = false;

            if ($toolDone && $spinDone) {

                global $wpdb;

                $plugin = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];

                $magic360_selector_path = '/wp-content/plugins/mod_wordpress_magic360/magic360/core/360icon.png';
                
                $scOptions = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix . $tool."_store WHERE id = ".(int)$spin_id);
                
                if ($scOptions){

                    $additionalOptions = magictoolbox_WordPress_MagicZoomPlus_parse_option_from_string($scOptions->additional_options);
                    
                    if ($additionalOptions['thumbnail_size'] == 'custom') {
                        $sMaxWidth = $additionalOptions['thumbnail_width'];
                        $sMaxHeight = $additionalOptions['thumbnail_height'];
                    } else {
                        global $_wp_additional_image_sizes;

                        $imageSize = $additionalOptions['thumbnail_size'];

                        if (in_array( $imageSize, array('thumbnail', 'medium', 'medium_large', 'large'))) {
                            $sMaxWidth = (int)get_option($imageSize.'_size_w');
                            $sMaxHeight = (int)get_option($imageSize.'_size_h');
                        } else if (isset( $_wp_additional_image_sizes[$imageSize] ) ) {
                            $sMaxWidth = (int)$_wp_additional_image_sizes[$imageSize]['width'];
                            $sMaxHeight = (int)$_wp_additional_image_sizes[$imageSize]['height'];
                        }
                    }

                    $sizeStyle = '';
                    if ((int)$sMaxHeight && (int)$sMaxWidth) {
                        $sizeStyle = ' style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;" ';
                    } 
                }
    
            
                
                $magic360_selector = '<a class="active-selector" href="#" data-slide-id="360" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img '.$sizeStyle.' src="'.get_site_url().'/'.ltrim($magic360_selector_path,'/').'" alt="360" /></a>';

                $magictoolbox_page_has_shortcode_gallery = true;

                $content = preg_replace('/(<a class="Magic[^>]*".*?<\/a>)/ims', '<div data-slide-id="zoom">$1</div><div style="display:block;" data-slide-id="360">'.$spin.'</div>', $content);

                $content = str_replace('<a data-zoom-id=', '<a data-slide-id="zoom" data-zoom-id=', $content);
                
                $content = preg_replace('/(<div id="MagicToolboxSelectors.*?>)/ims', '$1'.$magic360_selector, $content);

                $content = '<div class="magicgallery-shortcode-content">'.$content.'</div>';
            } else {
                $content = '';

                if (!$spinDone) {
                    $content .= 'Wrong Mgic360 shortcode id <b>'.$spin_id.'</b></br></br>';
                }

                if (!$toolDone) {
                    $content .= 'Wrong '.$tool.' shortcode id <b>'.$tool_id.'</b></br></br>';
                }
            }
        }

        return $content;

    } );
}

?>