<?php
/*
Plugin Name: MrSeokar Inline Woocommerce Products
Description: Automatically insert products with different styles between blog post paragraphs.
Version: 1.2
Author: Ebrahim Hanafi
Plugin URI: https://ehm.ir/inline-products-in-blog/
*/

function ehm_mrseokar_products_enqueue_styles() {
    wp_enqueue_style('ehm-mrseokar-products-styles', plugin_dir_url(__FILE__) . 'assets/style.css');
    $mrseokar_css = "
    .mrseokar-product{padding:10px;border-radius:10px;border:1px solid #ddd;display:table;width:100%;margin-top:50px!important;margin-bottom:50px!important}.mrseokar-product .mrseokar-thumb{max-width:100%;height:auto;margin-bottom:10px}.mrseokar-product .mrseokar-title{margin:0}.mrseokar-product .mrseokar-discounted,.mrseokar-product .mrseokar-price{font-weight:700;color:red;padding:10px}.mrseokar-price{text-decoration:line-through}.mrseokar-discounted{font-size:larger}.mrseokar-product .mrseokar-buy{display:inline-block;padding:10px;background-color:#4caf50;color:#fff;text-decoration:none;border-radius:5px;margin-top:10px;text-align:center}.mrseokar-product.style-2 .mrseokar-card{width:10%;display:table-cell}.mrseokar-product.style-2 .mrseokar-buy{display:table-cell}.mrseokar-product.style-2 .mrseokar-title{text-align:right;padding-right:15px}.mrseokar-product.style-2 .mrseokar-card img{border:1px solid #ddd;border-radius:10px}.mrseokar-product.style-1{width:35%;margin:0 auto}.mrseokar-product.style-1 a.mrseokar-buy,.mrseokar-product.style-1 a.mrseokar-title{display:block}.mrseokar-product.style-3 a.mrseokar-buy{display:block;bottom:0;width:100%;padding:5px;height:40px;position:absolute}.mrseokar-product.style-3 .mrseokar-title{position:absolute;bottom:70px;padding:10px;width:100%;color:#fff!important}.mrseokar-product.style-3 .mrseokar-card:before{background:linear-gradient(1deg,#000 0,rgba(0,0,0,0) 100%);width:100%;display:block;content:' ';position:absolute;height:-webkit-fill-available}.mrseokar-product.style-3 span.mrseokar-price{position:absolute;bottom:34px;left:calc(50% - 10px)}.mrseokar-product.style-3 .mrseokar-discounted{position:absolute;bottom:34px;left:calc(50% - 136px)}.mrseokar-product.style-3{width:35%;margin:0 auto;position:relative;padding:0;overflow:hidden}.mrseokar-product.style-4 .mrseokar-title{display:inline-block;margin:10px;vertical-align:bottom}.mrseokar-product.style-4 .mrseokar-card{width:50%;display:table-cell}.mrseokar-product.style-4{width:60%;margin:0 auto;padding:0;overflow:hidden;display:table}.mrseokar-product.style-4 a.mrseokar-buy{display:block;margin:10px}.mrseokar-product.style-4 img.mrseokar-thumb{padding:0;margin:0}@media (max-width:767px){.mrseokar-product.style-3{width:100%}.mrseokar-product.style-1{width:70%}.mrseokar-product.style-2 .mrseokar-buy{display:block}.mrseokar-product.style-2 .mrseokar-card{width:100%;display:block}.mrseokar-product.style-4{width:70%;display:block}}span.mrseokar-badge{position:absolute;margin-top:-43px;padding:0 10px;border-top-left-radius:10px;border-top-right-radius:10px}.mrseokar-product.style-4 span.mrseokar-badge{margin-top:-33px;margin-right:12px}";
    $mrseokar_css .= "
    .mrseokar-product {background-color: " . get_option('background_color', '#f7f7f7') . " !important;}
    .mrseokar-buy {background-color: " . get_option('button_color', '#4caf50') . " !important;color: #fff !important;}
    .mrseokar-product .mrseokar-title {color: " . get_option('product_name_color', '#333333') . " !important;}
    .mrseokar-price {color: " . get_option('regular_price_color', '#bbbbbb') . " !important;}
    .mrseokar-discounted {color: " . get_option('sale_price_color', '#00a91e') . " !important;}
    span.mrseokar-badge {background-color: " . get_option('button_color', '#4caf50') . " !important;color: #fff !important;}
    ";
    wp_add_inline_style('ehm-mrseokar-products-styles', $mrseokar_css);
}
add_action('wp_enqueue_scripts', 'ehm_mrseokar_products_enqueue_styles');

function mrseokar_admin_page() {
    add_menu_page(
        __('MrSeokar Plugin', 'mrseokar'),
        __('MrSeokar', 'mrseokar'),
        'manage_options',
        'mrseokar_products_settings',
        'render_mrseokar_products_settings',
         plugin_dir_url(__FILE__) . 'assets/mrseokar.svg'
    );
} 

function render_mrseokar_products_settings() {
    ?>
    <div class="wrap">
        <h1><img style="border-radius: 50%;" src="https://secure.gravatar.com/avatar/3c10fd798516e1185c4d62f1285e498e?s=50&d=mm&r=g" alt="<?php _e('MrSeokar', 'mrseokar'); ?>" /> <?php _e('MrSeokar Sales Boost Plugin', 'mrseokar'); ?></h1>
        <form method="post" action="options.php">
            <?php settings_fields('mrseokar_products_settings_group'); ?>
            <?php do_settings_sections('mrseokar_products_settings'); ?>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

function mrseokar_products_settings_init() {
    register_setting('mrseokar_products_settings_group', 'number_of_products', array('default' => 5));
    register_setting('mrseokar_products_settings_group', 'finding_method', array('default' => 'last_words_priority'));
    register_setting('mrseokar_products_settings_group', 'header_tags', array('default' => 'h2'));
    register_setting('mrseokar_products_settings_group', 'selected_tags', array('default' => 'all'));
    register_setting('mrseokar_products_settings_group', 'buy_text', array('default' => __('Buy Now', 'mrseokar')));
    register_setting('mrseokar_products_settings_group', 'show_sale_price', array('default' => true));
    register_setting('mrseokar_products_settings_group', 'show_regular_price', array('default' => true));
    register_setting('mrseokar_products_settings_group', 'show_image', array('default' => true));
    register_setting('mrseokar_products_settings_group', 'product_name_html_tag', array('default' => 'h3'));
    register_setting('mrseokar_products_settings_group', 'product_style', array('default' => 'style-2'));
    register_setting('mrseokar_products_settings_group', 'mrseokar_badge_text', array('default' => __('You May Also Like', 'mrseokar')));
    register_setting('mrseokar_products_settings_group', 'display_mrseokar_badge', array('default' => '1'));
    register_setting('mrseokar_products_settings_group', 'display_zero_price_products', array('default' => '1'));
    
    add_settings_section(
        'mrseokar_products_settings_section',
        __('Automatically Add Products in the Middle of Article Paragraphs', 'mrseokar'),
        'render_mrseokar_products_settings_section',
        'mrseokar_products_settings'
    );
    
    add_settings_field(
        'number_of_products',
        __('Number of products', 'mrseokar'),
        'number_of_products_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'finding_method',
        __('Method of finding related products', 'mrseokar'),
        'finding_method_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'header_tags',
        __('Products to be added before which tags in the post content', 'mrseokar'),
        'header_tags_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'selected_tags',
        __('Where to suggest products', 'mrseokar'),
        'selected_tags_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'buy_text',
        __('Buy button text', 'mrseokar'),
        'buy_text_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'show_sale_price',
        __('Show sale price', 'mrseokar'),
        'show_sale_price_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'show_regular_price',
        __('Show regular price', 'mrseokar'),
        'show_regular_price_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'show_image',
        __('Show product image', 'mrseokar'),
        'show_image_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'product_name_html_tag',
        __('HTML tag of the product title', 'mrseokar'),
        'product_name_html_tag_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'product_style',
        __('Product style', 'mrseokar'),
        'product_style_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );

    $color_settings = array(
        'background_color'     => array(
            'label'  => __('Background color of the recommendations box', 'mrseokar'),
            'default' => '#f7f7f7',
        ),
        'button_color'         => array(
            'label'  => __('Buy button color', 'mrseokar'),
            'default' => '#4caf50',
        ),
        'product_name_color'   => array(
            'label'  => __('Product name color', 'mrseokar'),
            'default' => '#333333',
        ),
        'regular_price_color'  => array(
            'label'  => __('Regular price color', 'mrseokar'),
            'default' => '#bbbbbb',
        ),
        'sale_price_color'     => array(
            'label'  => __('Sale price color', 'mrseokar'),
            'default' => '#00a91e',
        ),
    );
    
    foreach ($color_settings as $setting => $args) {
        $label = $args['label'];
        $default = $args['default'];
    
        register_setting('mrseokar_products_settings_group', $setting, array('default' => $default));
        add_settings_field(
            $setting,
            $label,
            'color_option_callback',
            'mrseokar_products_settings',
            'mrseokar_products_settings_section',
            array('setting' => $setting, 'default' => $default)
        );
    }
    
    add_settings_field(
        'mrseokar_badge_text',
        __('Text of the offer label', 'mrseokar'),
        'mrseokar_badge_text_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'display_mrseokar_badge',
        __('Display the offer label', 'mrseokar'),
        'display_mrseokar_badge_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );
    
    add_settings_field(
        'display_zero_price_products',
        __('Display Out-of-Stock or Zero Price Products', 'mrseokar'),
        'display_zero_price_products_callback',
        'mrseokar_products_settings',
        'mrseokar_products_settings_section'
    );

    add_settings_section('mrseokar_products_settings_section', '', 'close_mrseokar_settings_container', 'mrseokar_admin_page');
}

function render_mrseokar_products_settings_section() {
    echo '
    <style>
    table.form-table td,table.form-table th{padding-top:10px}table.form-table tr:nth-child(2n){background-color:#f7f7f7}table.form-table th{padding-right:10px}.form-table td{padding-top:0;padding-bottom:0}.form-table th{width:400px;padding:0}.mrseokar-settings-container{background-color:#fff;padding:15px;border-radius:10px;box-shadow:0 0 5px #ddd;border:1px solid #ddd}.mrseokar-section-title{font-size:18px;font-weight:700;margin-bottom:10px}.mrseokar-input,.mrseokar-select{width:400px !important;padding:8px;margin-bottom:10px;border:1px solid #ccc;border-radius:3px;box-sizing:border-box}
    </style>
    ';
    echo '<div class="mrseokar-settings-container">';
    echo '<a target="_blank" href="https://ehm.ir"><img src="https://ehm.ir/wp-content/uploads/plugin-header.png"></a>';
    echo '<p class="mrseokar-section-title">' . __('Inline Products Settings:', 'mrseokar') . '</p>';
    echo '<div class="notice-danger ">
        <p><strong>' . __('Attention', 'mrseokar') . '</strong>: ' . __('This plugin automatically detects products from post titles, It may not be accurate,', 'mrseokar') . '<br>
        ' . __('So we provided the option to define specific product categories or IDs for each post, and customize the plugin for that article or post', 'mrseokar') . '<br>
        ' . __('Simply edit the desired article or post and select the relevant category or desired IDs from the custom settings section', 'mrseokar') . '
        </p>
        <p style="background-color: #f7f7f7;padding: 10px;border: 1px solid #ddd;">' . __('Contact MrSeokar:', 'mrseokar') . ' <a href="https://t.me/seokar">@Seokar</a> ' . __('And thank him for writing this awesome plugin 😂', 'mrseokar') . '</p>
        </div>';
}

function number_of_products_callback() {
    $value = get_option('number_of_products', 5);
    ?>
    <input class="mrseokar-input" type="number" name="number_of_products" value="<?php echo esc_attr($value); ?>" />
    <?php
}

function finding_method_callback() {
    $finding_methods = array(
        'last_words_priority' => __('Use the title of the post with priority on the last words', 'mrseokar'),
        'first_words_priority' => __('Use the title of the post with priority on the first words', 'mrseokar'),
        'focus_keyword_priority' => __('Use the Focus keyword (Yoast or Rankmath)', 'mrseokar'),
        'category_from_title' => __('Smart Detect of related products', 'mrseokar'),
    );

    $current_value = get_option('finding_method', 'last_words_priority');

    echo '<select name="finding_method">';
    foreach ($finding_methods as $value => $label) {
        echo '<option value="' . esc_attr($value) . '" ' . selected($current_value, $value, false) . '>' . esc_html($label) . '</option>';
    }
    echo '</select>';
}

function header_tags_callback() {
    $value = get_option('header_tags', 'h2');
    ?>
    <select class="mrseokar-select" name="header_tags">
        <option value="h2" <?php selected($value, 'h2'); ?>>&#x3C;h2&#x3E;</option>
        <option value="h3" <?php selected($value, 'h3'); ?>>&#x3C;h3&#x3E;</option>
        <option value="h4" <?php selected($value, 'h4'); ?>>&#x3C;h4&#x3E;</option>
        <option value="h5" <?php selected($value, 'h5'); ?>>&#x3C;h5&#x3E;</option>
        <option value="h6" <?php selected($value, 'h6'); ?>>&#x3C;h6&#x3E;</option>
        <option value="p" <?php selected($value, 'p'); ?>>&#x3C;p&#x3E;</option>
        <option value="img" <?php selected($value, 'img'); ?>>&#x3C;img&#x3E;</option>
    </select>
    <?php
}

function selected_tags_callback() {
    $selected_tags = get_option('selected_tags', 'all');
    ?>
    <select class="mrseokar-select" name="selected_tags">
        <option value="all" <?php selected($selected_tags, 'all'); ?>><?php _e('All of the above tags', 'mrseokar'); ?></option>
        <option value="even" <?php selected($selected_tags, 'even'); ?>><?php _e('Even tags', 'mrseokar'); ?></option>
        <option value="odd" <?php selected($selected_tags, 'odd'); ?>><?php _e('Odd tags', 'mrseokar'); ?></option>
    </select>
    <?php
}

function buy_text_callback() {
    $value = get_option('buy_text', __('Buy Now', 'mrseokar'));
    ?>
    <input class="mrseokar-input" type="text" name="buy_text" value="<?php echo esc_attr($value); ?>" />
    <?php
}

function show_sale_price_callback() {
    $value = get_option('show_sale_price', true);
    ?>
    <select class="mrseokar-select" name="show_sale_price">
        <option value="1" <?php selected($value, '1'); ?>><?php _e('Yes', 'mrseokar'); ?></option>
        <option value="0" <?php selected($value, '0'); ?>><?php _e('No', 'mrseokar'); ?></option>
    </select>
    <?php
}

function show_regular_price_callback() {
    $value = get_option('show_regular_price', true);
    ?>
    <select class="mrseokar-select" name="show_regular_price">
        <option value="1" <?php selected($value, '1'); ?>><?php _e('Yes', 'mrseokar'); ?></option>
        <option value="0" <?php selected($value, '0'); ?>><?php _e('No', 'mrseokar'); ?></option>
    </select>
    <?php
}

function show_image_callback() {
    $value = get_option('show_image', true);
    ?>
    <select class="mrseokar-select" name="show_image">
        <option value="1" <?php selected($value, '1'); ?>><?php _e('Yes', 'mrseokar'); ?></option>
        <option value="0" <?php selected($value, '0'); ?>><?php _e('No', 'mrseokar'); ?></option>
    </select>
    <?php
}

function product_name_html_tag_callback() {
    $value = get_option('product_name_html_tag', 'h3');
    ?>
    <select class="mrseokar-select" name="product_name_html_tag">
        <option value="p" <?php selected($value, 'p'); ?>>&#x3C;p&#x3E;</option>
        <option value="span" <?php selected($value, 'span'); ?>>&#x3C;span&#x3E;</option>
        <option value="strong" <?php selected($value, 'strong'); ?>>&#x3C;strong&#x3E;</option>
        <option value="h2" <?php selected($value, 'h2'); ?>>&#x3C;h2&#x3E;</option>
        <option value="h3" <?php selected($value, 'h3'); ?>>&#x3C;h3&#x3E;</option>
        <option value="h4" <?php selected($value, 'h4'); ?>>&#x3C;h4&#x3E;</option>
        <option value="h5" <?php selected($value, 'h5'); ?>>&#x3C;h5&#x3E;</option>
        <option value="h6" <?php selected($value, 'h6'); ?>>&#x3C;h6&#x3E;</option>
    </select>
    <?php
}
function product_style_callback() {
    $value = get_option('product_style', 'style-1');
    ?>
    <select class="mrseokar-select" name="product_style">
        <option value="style-1" <?php selected($value, 'style-1'); ?>><?php _e('Style 1', 'mrseokar'); ?></option>
        <option value="style-2" <?php selected($value, 'style-2'); ?>><?php _e('Style 2', 'mrseokar'); ?></option>
        <option value="style-3" <?php selected($value, 'style-3'); ?>><?php _e('Style 3', 'mrseokar'); ?></option>
        <option value="style-4" <?php selected($value, 'style-4'); ?>><?php _e('Style 4', 'mrseokar'); ?></option>
    </select>
    <?php
}

function color_option_callback($args) {
    $setting = $args['setting'];
    $color_value = get_option($setting, $args['default']); 

    ?>
    <input type="text" name="<?php echo esc_attr($setting); ?>" class="color-field" value="<?php echo esc_attr($color_value); ?>" style="background-color: <?php echo esc_attr($color_value); ?>;" />
    <script>
        jQuery(document).ready(function ($) {

            $('.color-field[name="<?php echo esc_attr($setting); ?>"]').wpColorPicker({
                defaultColor: '<?php echo esc_attr($args['default']); ?>'
            });
        });
    </script>
    <?php
}

function mrseokar_badge_text_callback() {
    $value = get_option('mrseokar_badge_text', __('You May Also Like', 'mrseokar'));
    ?>
    <input class="mrseokar-input" type="text" name="mrseokar_badge_text" value="<?php echo esc_attr($value); ?>" />
    <?php
}

function display_mrseokar_badge_callback() {
    $value = get_option('display_mrseokar_badge', '1');
    ?>
    <select class="mrseokar-select" name="display_mrseokar_badge">
        <option value="1" <?php selected($value, '1'); ?>><?php _e('Show', 'mrseokar'); ?></option>
        <option value="0" <?php selected($value, '0'); ?>><?php _e('Hide', 'mrseokar'); ?></option>
    </select>
    <?php
}

function display_zero_price_products_callback() {
    $value = get_option('display_zero_price_products', '1');
    ?>
    <select class="mrseokar-select" name="display_zero_price_products">
        <option value="1" <?php selected($value, '1'); ?>><?php _e('Yes', 'mrseokar'); ?></option>
        <option value="0" <?php selected($value, '0'); ?>><?php _e('No', 'mrseokar'); ?></option>
    </select>
    <?php
}

function close_mrseokar_settings_container() {
    echo '</div>'; 
}

add_filter('the_content', 'insert_products_inline_posts');

add_action('admin_menu', 'mrseokar_admin_page');

add_action('admin_init', 'mrseokar_products_settings_init');

function insert_products_inline_posts($content) {
    //if (is_singular(post)) {
    if (is_singular() && !is_front_page() && !is_page() && !is_product()) {
        require_once(plugin_dir_path(__FILE__) . 'simple_html_dom.php');
        $post_title = get_the_title();

        $post_title = preg_replace('/[^\p{L}\p{N}\s]/u', '', $post_title);

        $keywords = preg_split('/\s+/', $post_title);

        $keywords = array_filter($keywords, function ($word) {
            return mb_strlen($word, 'UTF-8') >= 3;
        });
        
        $finding_method = get_option('finding_method', 'last_words_priority');

        if (!empty($keywords)) {

            $number_of_products = get_option('number_of_products', 5); 
            $display_zero_price_products = get_option('display_zero_price_products', '1');            
            $all_args = array();
            $product_ids = array();
            
            if ($finding_method === 'last_words_priority' || $finding_method === 'first_words_priority') {
                foreach ($keywords as $keyword) {
                    $args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => $number_of_products,
                        's'              => $keyword
                    );
                    if ($display_zero_price_products === '0') {
                        $args['meta_query'][] = array(
                            'relation' => 'OR',
                            array(
                                'key'     => '_price',
                                'value'   => 0,
                                'compare' => '>',
                            ),
                            array(
                                'key'     => '_stock_status',
                                'value'   => 'outofstock',
                                'compare' => '!=',
                            ),
                        );
                    }
                    $query = new WP_Query($args);
    
                    if ($query->have_posts()) {
                        while ($query->have_posts()) {
                            $query->the_post();
                            $product_ids[] = get_the_ID();
                        }
                        wp_reset_postdata();
                    }
                }
            } elseif ($finding_method === 'focus_keyword_priority') {
                $focus_keyword = '';
            
                if (function_exists('wpseo_auto_load')) {
                    $focus_keyword = get_post_meta(get_the_ID(), '_yoast_wpseo_focuskw', true);
                }
            
                if (empty($focus_keyword) && function_exists('rank_math')) {
                    $focus_keyword = rank_math_get_post_meta(get_the_ID(), 'focuskw');
                }
            
                if (!empty($focus_keyword)) {
                    $args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => $number_of_products,
                        's'              => $focus_keyword
                    );
            
                    if ($display_zero_price_products === '0') {
                        $args['meta_query'][] = array(
                            'relation' => 'OR',
                            array(
                                'key'     => '_price',
                                'value'   => 0,
                                'compare' => '>',
                            ),
                            array(
                                'key'     => '_stock_status',
                                'value'   => 'outofstock',
                                'compare' => '!=',
                            ),
                        );
                    }
            
                    $query = new WP_Query($args);
            
                    if ($query->have_posts()) {
                        while ($query->have_posts()) {
                            $query->the_post();
                            $product_ids[] = get_the_ID();
                        }
                        wp_reset_postdata();
                    }
                }
            } elseif ($finding_method === 'category_from_title') {
                $all_categories = get_terms('product_cat', array('hide_empty' => 0));
                
                foreach ($all_categories as $category) {
                    if (stripos($post_title, $category->name) !== false) {
                        $args = array(
                            'post_type'      => 'product',
                            'posts_per_page' => $number_of_products,
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'product_cat',
                                    'field'    => 'id',
                                    'terms'    => $category->term_id,
                                ),
                            ),
                        );
            
                        if ($display_zero_price_products === '0') {
                            $args['meta_query'][] = array(
                                'relation' => 'OR',
                                array(
                                    'key'     => '_price',
                                    'value'   => 0,
                                    'compare' => '>',
                                ),
                                array(
                                    'key'     => '_stock_status',
                                    'value'   => 'outofstock',
                                    'compare' => '!=',
                                ),
                            );
                        }
            
                        $query = new WP_Query($args);
            
                        if ($query->have_posts()) {
                            while ($query->have_posts()) {
                                $query->the_post();
                                $product_ids[] = get_the_ID();
                            }
                            wp_reset_postdata();
                        }
                    }
                }
            }
            
            $mrseokar_category_id = get_post_meta(get_the_ID(), '_mrseokar_category_id', true);
            $mrseokar_product_ids = get_post_meta(get_the_ID(), '_mrseokar_product_ids', true);
            
            if (!isset($mrseokar_category_id) || $mrseokar_category_id === '' || $mrseokar_category_id == -1) {
                $mrseokar_category_id = array();
            }

            if (!empty($mrseokar_category_id) || !empty($mrseokar_product_ids)) {
                if (!empty($mrseokar_category_id) && !empty($mrseokar_product_ids)) {
                    $all_args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => $number_of_products,
                        'tax_query'      => array(
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'id',
                                'terms'    => $mrseokar_category_id, 
                            ),
                        ),
                        'post__in'       => array_map('intval', explode(',', $mrseokar_product_ids)),
                    );
                } elseif (!empty($mrseokar_category_id)) {

                    $all_args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => $number_of_products,
                        'tax_query'      => array(
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'id',
                                'terms'    => $mrseokar_category_id, 
                            ),
                        ),
                    );
                } elseif (!empty($mrseokar_product_ids)) {
                    $all_args = array(
                        'post_type'      => 'product',
                        'posts_per_page' => $number_of_products,
                        'post__in'       => array_map('intval', explode(',', $mrseokar_product_ids)),
                        'orderby'        => 'post__in',
                    );
                }
            } else {
                if ($finding_method === 'last_words_priority'){
                    $product_ids = array_reverse($product_ids);
                }
                $all_args = array(
                    'post_type'      => 'product',
                    'post__in'       => $product_ids,
                    'posts_per_page' => $number_of_products,
                    'orderby'        => 'post__in',
                );
            }

            $query = new WP_Query($all_args);
            $products = $query->get_posts();

            $dom_content = str_get_html($content);
            $h_tag = get_option('header_tags', 'h2');
            $selected_tags = get_option('selected_tags', 'all');
            $h_index = 0;
            $buy_text = get_option('buy_text', __('Buy Now', 'mrseokar'));
            $show_sale_price = get_option('show_sale_price', true);
            $show_regular_price = get_option('show_regular_price', true);
            $show_image = get_option('show_image', true);
            $product_style = get_option('product_style', 'style-1');
            $display_mrseokar_badge = get_option('display_mrseokar_badge', '1');
            $mrseokar_badge_text = get_option('mrseokar_badge_text', __('You May Also Like', 'mrseokar'));
            
            foreach ($products as $product) {
                $product_html = '<div class="mrseokar-product ' . esc_attr($product_style) . '">';
                if ($display_mrseokar_badge == '1') {
                    $product_html .= '<span class="mrseokar-badge">' . esc_html($mrseokar_badge_text) . '</span>';
                }
                $product_html .= '<div class="mrseokar-card">';
                if ($show_image) {
                    $product_html .= '<img class="mrseokar-thumb" src="' . esc_url(get_the_post_thumbnail_url($product->ID)) . '" />';
                }
                $product_name_tag = get_option('product_name_html_tag', 'h3');
                $product_html .= '</div><a class="mrseokar-title" target="_blank" href="' . get_permalink($product->ID) . '"><' . esc_html($product_name_tag) . '>' . esc_html($product->post_title) . '</' . esc_html($product_name_tag) . '></a>';

                if ($show_regular_price || $show_sale_price) {
                    $product_type = get_post_meta($product->ID, '_product_type', true);
                    if ($product_type === 'variable') {
                        $available_variations = $product->get_available_variations();
                
                        $min_price = PHP_INT_MAX;
                        $max_price = 0;
                
                        foreach ($available_variations as $variation) {
                            $variation_id = $variation['variation_id'];
                            $variation_price = get_post_meta($variation_id, '_price', true);
                
                            $min_price = min($min_price, $variation_price);
                            $max_price = max($max_price, $variation_price);
                        }
                
                        if ($show_regular_price) {
                            $product_html .= '<span class="mrseokar-price">' . wc_price($min_price) . ' - ' . wc_price($max_price) . '</span>';
                        }
                    } else {
                        $regular_price = get_post_meta($product->ID, '_regular_price', true);
                        $sale_price = get_post_meta($product->ID, '_price', true);
                
                        if ($regular_price != 0 || $sale_price != 0) {
                            if ($show_regular_price) {
                                $product_html .= '<span class="mrseokar-price">' . wc_price($regular_price) . '</span>';
                            }
                            if ($show_sale_price) {
                                $product_html .= '<span class="mrseokar-discounted">' . wc_price($sale_price) . '</span>';
                            }
                        }
                    }
                }

                $product_html .= '<a href="' . esc_url(get_permalink($product->ID)) . '" class="mrseokar-buy" target="_blank">' . esc_html($buy_text) . '</a>';
                $product_html .= '</div>';

                $h_tags_found = $dom_content->find($h_tag);
                if (!empty($h_tags_found)) {
                    if (isset($h_tags_found[$h_index])) {
                        if ($selected_tags == 'odd') {
                            if ($h_index % 2 == 1) {
                                $h_tag_found = $h_tags_found[$h_index];
                                $h_tag_content = $h_tag_found->outertext;
                                $content = preg_replace('/' . preg_quote($h_tag_content, '/') . '/', $product_html . $h_tag_content, $content, 1);
                            }
                        } elseif ($selected_tags == 'even') {
                            if ($h_index % 2 == 0) {
                                $h_tag_found = $h_tags_found[$h_index];
                                $h_tag_content = $h_tag_found->outertext;
                                $content = preg_replace('/' . preg_quote($h_tag_content, '/') . '/', $product_html . $h_tag_content, $content, 1);
                            }
                        }else{
                                $h_tag_found = $h_tags_found[$h_index];
                                $h_tag_content = $h_tag_found->outertext;
                                $content = preg_replace('/' . preg_quote($h_tag_content, '/') . '/', $product_html . $h_tag_content, $content, 1);
                        }
                    }
                }
                $h_index += 1;
            }
        }
    }

    return $content;
}

function render_mrseokar_post_settings_meta_box($post) {

    wp_nonce_field('mrseokar_post_settings_nonce', 'mrseokar_post_settings_nonce');

    $mrseokar_category_id = get_post_meta($post->ID, '_mrseokar_category_id', true);
    $mrseokar_product_ids = get_post_meta($post->ID, '_mrseokar_product_ids', true);

    ?>
    <table class="form-table">
        <tr valign="top">
            <th scope="row"><?php _e('Products Category', 'mrseokar'); ?></th>
            <td>
                <?php

                $current_category = ($mrseokar_category_id) ? $mrseokar_category_id : 0;

                wp_dropdown_categories(array(
                    'taxonomy'          => 'product_cat',
                    'name'              => 'mrseokar_category_id',
                    'orderby'           => 'name',
                    'selected'          => $current_category,
                    'show_option_none'  => __('-- Select Products Category --', 'mrseokar'),
                    'hide_empty'        => false, 
                    'hierarchical'      => 1,
                    'show_count'        => 0,
                    'class'             => 'regular-text',
                ));
                ?>
                <p class="description"><?php _e('Shows the products of this category in the recommendations of this post', 'mrseokar'); ?></p> 
            </td>
        </tr>
        <tr valign="top">
            <th scope="row"><?php _e('Product IDs', 'mrseokar'); ?></th>
            <td>
                <input type="text" name="mrseokar_product_ids" value="<?php echo esc_attr($mrseokar_product_ids); ?>" />
                <p class="description"><?php _e('Separate product IDs with a comma, for example: 1,2,3', 'mrseokar'); ?></p>
            </td>
        </tr>
    </table>
    <?php
}

function add_mrseokar_post_settings_meta_box() {
    $post_types = get_post_types(['public' => true]);
    foreach ($post_types as $post_type) {
        add_meta_box(
            'mrseokar_post_settings_meta_box',
            __('MrSeokar inline Products Custom Settings', 'mrseokar'),
            'render_mrseokar_post_settings_meta_box',
            $post_type,
            'normal',
            'high'
        );
    }
}


function mrseokar_admin_notice() {
    $user_id = get_current_user_id();
    $dismissed = get_user_meta($user_id, 'mrseokar_admin_notice_dismissed', true);

    if (!$dismissed) {
        echo '<div class="notice notice-success ">
                <p><strong>' . __('Attention', 'mrseokar') . '</strong>: ' . __('You are using the free MrSeokar plugin. Introduce us to your friends to support us and promote the culture of free plugins.', 'mrseokar') .
                '<a style="text-decoration:none" target="_blank" href="https://instagram.com/mr.seokar">Instagram</a> | <a style="text-decoration:none" target="_blank" href="https://ehm.ir">Website</a> | <a style="color:red" href="?page=mrseokar_products_settings&mrseokar-dismissed" style="text-decoration:none;">' . __('not show again', 'mrseokar') . '</a>
                </p>
            </div>';
    }
}

add_action('admin_notices', 'mrseokar_admin_notice');

function mrseokar_dismiss_notice() {
    $user_id = get_current_user_id();
    
    if (isset($_GET['mrseokar-dismissed'])) {
        add_user_meta($user_id, 'mrseokar_admin_notice_dismissed', 'true', true);
    }
}
add_action('admin_init', 'mrseokar_dismiss_notice');


add_action('add_meta_boxes', 'add_mrseokar_post_settings_meta_box');

add_action('save_post', 'save_mrseokar_post_settings');

function save_mrseokar_post_settings($post_id) {

    if (!isset($_POST['mrseokar_post_settings_nonce'])) {
        return;
    }

    if (!wp_verify_nonce($_POST['mrseokar_post_settings_nonce'], 'mrseokar_post_settings_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['mrseokar_category_id'])) {
        update_post_meta($post_id, '_mrseokar_category_id', sanitize_text_field($_POST['mrseokar_category_id']));
    }

    if (isset($_POST['mrseokar_product_ids'])) {
        update_post_meta($post_id, '_mrseokar_product_ids', sanitize_text_field($_POST['mrseokar_product_ids']));
    }
}

function mrseokar_load_textdomain() {
    load_plugin_textdomain('mrseokar', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}

add_action('plugins_loaded', 'mrseokar_load_textdomain');
