<?php

/**
 * Plugin Row Meta / Hooks
 *
 * @package  Masoud darvishi (THEMEFOUR.COM)
 * @category Enqueue
 * @author   ThemeFour Team
 * @license  GPL-2.0
 */

	
add_filter( 'plugin_row_meta', 'themefour_meta_row_wordpress_seo_premium', 10, 2 );
  function themefour_meta_row_wordpress_seo_premium( $links, $file ) {    
    if ( $file === 'wordpress-seo-premium/wp-seo-premium.php' ) {
		if (get_locale() == 'fa_IR'){
		$links[] = '<a href="https://themefour.com/" target="_blank" title="themefour.com"><strong>نگارش تم فور</strong></a>';
		}else{
		$links[] = '<a href="https://themefour.com/" target="_blank" title="themefour.com"><strong>themefour</strong></a>';
		}
        return array_merge( $links );
    }
    return (array) $links;
}


$site_information = get_transient( 'wpseo_site_information' );
if ( isset( $site_information->subscriptions ) && ( count( $site_information->subscriptions ) == 0 ) ) {
delete_transient( 'wpseo_site_information' );
delete_transient( 'wpseo_site_information_quick' );
}

add_filter( 'pre_http_request', function( $pre, $parsed_args, $url ){
$site_information = (object) [
'url' => NULL,
'subscriptions' => []
];

$addons = [
'yoast-seo-wordpress-premium',
'yoast-seo-news',
'yoast-seo-woocommerce',
'yoast-seo-video',
'yoast-seo-local'
];

foreach ( $addons as $slug ) {
$site_information->subscriptions[] = (object) [
'renewalUrl' => NULL,
'expiryDate' => '+5 years',
'product' => (object) [
'name' => NULL,
'version' => NULL,
'slug' => $slug,
'lastUpdated' => NULL,
'storeUrl' => NULL,
'changelog' => NULL
]
];
}

if ( strpos( $url, 'https://my.yoast.com/api/sites/current' ) !== false ) {
return [
'response' => [ 'code' => 200, 'message' => 'ОК' ],
'body' => json_encode( $site_information )
];
} else {
return $pre;
}
}, 10, 3 );

