<?php
// Preventing to direct access
defined( 'ABSPATH' ) OR die( 'Direct access not acceptable!' );

class WWS_Admin_Actions {

    public function __construct() {
        add_action( 'admin_init', array( $this, 'reset_settings' ) );
        add_action( 'admin_init', array( $this, 'admin_plugin_review' ) );
        add_action( 'admin_init', array( $this, 'dismiss_plugin_update_notice' ) );
    }

    /**
     * Reset plugin setting to default.
     */
    public function reset_settings() {
        if ( isset( $_GET['wws_action'] ) && 'wws_reset_settings' === $_GET['wws_action'] && wp_verify_nonce( $_GET['_wpnonce'] ) ) {
            require_once WWS_PLUGIN_PATH . 'includes/class-wws-install.php';

            foreach ( WWS_Install::default_options() as $name => $value ) {
                update_option( $name, $value );
            }

            wp_safe_redirect( wp_get_referer() );
        }
    }

    /**
     * Admin plugin review
     */
    public function admin_plugin_review() {
        if ( isset( $_GET['wws_action'] ) && 'wws_admin_plugin_reviewed' === $_GET['wws_action'] && wp_verify_nonce( $_GET['_wpnonce'] ) ) {
            update_option( 'wws_admin_plugin_review', 'yes' );
            wp_redirect( wp_get_referer() );
        }
    }

    /**
     * Dismiss admin plugin update notice.
     */
    public function dismiss_plugin_update_notice() {
        if ( isset( $_GET['wws_action'] ) && 'dismiss_plugin_update_notice' === $_GET['wws_action'] && wp_verify_nonce( $_GET['_wpnonce'] ) ) {
            update_option( 'wws_plugin_update_notice_status', 'yes' );
            wp_redirect( wp_get_referer() );
        }
    }

}

$wws_admin_actions = new WWS_Admin_Actions;