<?php

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

class WWS_Admin_Plugin_Update {
    
    public function __construct() {
        add_action( 'init', array( $this, 'check_update' ) );
    }

    /**
     * Check for the new verison.
     */
    public function check_update() {
		return;
        $purchase_code = get_option( 'sk_wws_license_key' );

        // If purchase code not set.
        if ( ! $purchase_code ) {
            return;
        }
        // Make sure the code is valid before sending it to server
        if ( ! preg_match( "/^(\w{8})-((\w{4})-){3}(\w{12})$/", $purchase_code ) ) {
            delete_option( 'sk_wws_license_key' );
            return;
        }

        require WWS_PLUGIN_PATH . 'includes/libraries/plugin-update-checker/plugin-update-checker.php';

        // Activation URL
        $update_url = add_query_arg( array(
            'cp_plugin_update'    => trim( $purchase_code ),
            'uniqid'              => uniqid(),
        ), 'http://envato.wecreativez.com/codecanyon/' );

        // Check for update.
        $myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
            $update_url,
            WWS_PLUGIN_FILE,
            'wc-whatsapp-support',
            24
        );
    }

}

$wws_admin_plugin_update = new WWS_Admin_Plugin_Update;