<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

$naga_updraftplus_strings = [];
$naga_updraftplus_strings[] = [
	'path'		=> WP_PLUGIN_DIR . '/updraftplus/includes/updraftplus-notices.php',
	'first'		=> 'https://wordpress.org/plugins/wp-optimize/',
	'second'	=> 'https://www.zhaket.com/web/wp-optimize-premium',
];
$naga_updraftplus_strings[] = [
	'path'		=> WP_PLUGIN_DIR . '/updraftplus/templates/wp-admin/settings/form-contents.php',
	'first'		=> 'https://wordpress.org/plugins/wp-optimize/',
	'second'	=> 'https://www.zhaket.com/web/wp-optimize-premium',
];

// Fix the Translations
add_action( 'naga_updraftplus_strings', 'naga_updraftplus_change_strings', 10, 1);
do_action( 'naga_updraftplus_strings', $naga_updraftplus_strings );
function naga_updraftplus_change_strings( $naga_updraftplus_strings ) {
	foreach ( $naga_updraftplus_strings as $string  ) {
		if ( file_exists( $string['path'] ) ) {
			$content = file_get_contents($string['path']);
			if ( strstr( $content, $string['first'] ) ) {
				$content = str_replace( $string['first'], $string['second'], $content );
				file_put_contents($string['path'], $content);
			}
		}
	}
} // Good Job :)