<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Show a notice to update the PHP version
 * Since 2.22.23.25
 */
function naga_updraftplus_php_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'According to {%1$s} the PHP version of your host must be at least {%2$s} or higher! Please update your host PHP version to be able to activate {%3$s} and use the pro version. %4$s', 'naga-updraftplus-notices' ),
				
				'<a href="https://wordpress.org/about/requirements/" target="_blank" rel="noopener noreferrer">' . __('WordPress Requirements', 'naga-updraftplus-notices').'</a>',
				
				naga_updraftplus_min_reqiered_php,
				
				naga_updraftplus_get_plugin_name(),
				
				'<a href="https://nagatheme.com/how-to-change-host-php-version/" target="_blank" rel="noopener noreferrer">' . __('Please check this article for more informations!', 'naga-updraftplus-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

/**
 * Show a notice to activate ionCube on server
 * Since 2.22.23.25
 */
function naga_updraftplus_ioncube_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'Unfortunately, {%1$s} settings are Disabled! The Product PHP files are encrypted for more performance and security! ionCube Loader is required to be installed in your host! Please contact your hosting support and ask them to install the ioncube loader! %2$s', 'naga-updraftplus-notices' ),
				
				naga_updraftplus_get_plugin_name(),
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">' . __('Please check this article for more informations!', 'naga-updraftplus-notices').'</a>'
				
				);
			?>
		</p>
	</div>
	
	<?php
}

/**
 * Show a notice to update the ionCube version
 * Since 2.22.23.25
 */
function naga_updraftplus_ioncube_version_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			
			echo sprintf(
			
				__( 'Unfortunately, {%1$s} settings are Disabled! The Product PHP files are encrypted for more performance and security by ioncube! The ioncube loader is active in your host but its version is {%2$s} while it must be at least {%3$s} so that you can use this product. Please contact your hosting support and ask them to update the ioncube loader! %4$s', 'naga-updraftplus-notices' ),
				
				naga_updraftplus_get_plugin_name(),
				
				naga_updraftplus_get_ioncube_loader_version(),
				
				naga_updraftplus_min_reqiered_ioncube,
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">' . __('Please check this article for more informations!', 'naga-updraftplus-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

/**
 * Get the server ionCube version to show in the notice
 * Since 2.22.23.25
 */
function naga_updraftplus_get_ioncube_loader_version() {
	
	if( is_admin() ) {
		
		if( function_exists( 'ioncube_loader_version' ) ) {
			
			$ioncube_loader_version = ioncube_loader_version();
			
			return $ioncube_loader_version;
			
		} else {
			
			return __( 'NAN', 'naga-updraftplus-notices' );
			
		}
		
	}
	
}

/**
 * Get the plugin name to show in the notice
 * Since 2.22.23.25
 */
function naga_updraftplus_get_plugin_name() {
	
	if( is_admin() ) {
		
		if( is_plugin_active( 'updraftplus/updraftplus.php' ) ) {
			
			$plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/updraftplus/updraftplus.php' );
			
			$plugin_name = $plugin_data['Name'];
		
			return $plugin_name;
			
		}
		
	}
	
}

/**
 * Disable options to protect the user from confusing about License!
 * Even if this function were removed, options still don't work,
 * Untill the user activate the License
 * Since 2.22.23.25
 */
function naga_updraftplus_deactivate_licenses() {
		
	remove_submenu_page( 'options-general.php', 'updraftplus' );
	
}