<?php
class IRPP_Tabs {
    private $tabs = array();

    function init() {
        global $irpp;
        if($irpp->Utils->isAdminUser()) {
            add_action('admin_menu', array(&$this, 'attachMenu'));
            add_filter('plugin_action_links', array(&$this, 'pluginActions'), 10, 2);
            if($irpp->Utils->isPluginPage()) {
                add_action('admin_enqueue_scripts', array(&$this, 'enqueueScripts'));
            }
        }
    }

    function attachMenu() {
        global $irpp;
        $name='نوشته‌های مرتبط هوشمند';
        add_submenu_page('options-general.php'
            , $name, $name
            , 'manage_options', IRPP_PLUGIN_SLUG, array(&$this, 'showTabPage'));
    }
    function pluginActions($links, $file) {
        global $irpp;
        if($file==IRPP_PLUGIN_SLUG.'/index.php'){
            $settings = "<a href='".IRPP_PAGE_SETTINGS."'>" . $irpp->Lang->L('Settings') . '</a> ';
            $links = array_merge(array($settings), $links);
        }
        return $links;
    }
    function enqueueScripts() {
        global $irpp;
        wp_enqueue_script('jquery');
        wp_enqueue_script('suggest');
        wp_enqueue_script('jquery-ui-autocomplete');

        $uri='//maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css';
        wp_enqueue_style('font-awesome', $uri);

        $this->wpEnqueueStyle('assets/css/style.css');
        $this->wpEnqueueStyle('assets/deps/select2-3.5.2/select2.css');
        $this->wpEnqueueScript('assets/deps/select2-3.5.2/select2.min.js');
        $this->wpEnqueueScript('assets/deps/starrr/starrr.js');

        $this->wpEnqueueScript('assets/deps/qtip/jquery.qtip.min.js');
        $this->wpEnqueueScript('assets/js/common.js');
    }
    function wpEnqueueStyle($uri, $name='') {
        if($name=='') {
            $name=explode('/', $uri);
            $name=$name[count($name)-1];
            $dot=strrpos($name, '.');
            if($dot!==FALSE) {
                $name=substr($name, 0, $dot);
            }
            $name=IRPP_PLUGIN_PREFIX.'_'.$name;
        }

        $v='?v='.IRPP_PLUGIN_VERSION;
        wp_enqueue_style($name, IRPP_PLUGIN_URI.$uri.$v);
    }
    function wpEnqueueScript($uri, $name='', $version=FALSE) {
        if($name=='') {
            $name=explode('/', $uri);
            $name=$name[count($name)-1];
            $dot=strrpos($name, '.');
            if($dot!==FALSE) {
                $name=substr($name, 0, $dot);
            }
            $name=IRPP_PLUGIN_PREFIX.'_'.$name;
        }

        $v='?v='.IRPP_PLUGIN_VERSION;
        $deps=array();
        wp_enqueue_script($name, IRPP_PLUGIN_URI.$uri.$v, $deps, $version, FALSE);
    }

    function showTabPage() {
        global $irpp;

        $message='';
        $success=FALSE;
        $licenseKey='';
        if($irpp->Check->nonce('irpp_settings')) {
            $licenseKey=$irpp->Utils->qs('key', '');
            if($licenseKey=='' && $irpp->Options->getLicenseKey()!='') {
                $licenseKey=$irpp->Options->getLicenseKey();
                $success=$irpp->License->deactivate();
                $message='Deactivate';
            } elseif($licenseKey!='' && $licenseKey!=$irpp->Options->getLicenseKey()) {
                $success=$irpp->License->activate($licenseKey);
                $message='Activate';
            }
        }

        $defaultTab=IRPP_TAB_SETTINGS;
        if($irpp->Options->isShowWhatsNew()) {
            $tab=IRPP_TAB_WHATS_NEW;
            $defaultTab=$tab;
            $this->tabs[IRPP_TAB_WHATS_NEW]=$irpp->Lang->L('What\'s New');
            //$this->tabs[TCM_TAB_MANAGER]=$tcm->Lang->L('Start using the plugin!');
        } else {
            $tab = $irpp->Utils->qs('tab', $defaultTab);
            $this->tabs[IRPP_TAB_SETTINGS] = $irpp->Lang->L('تنظیمات');
            $this->tabs[IRPP_TAB_DOCS] = $irpp->Lang->L('راهنمای افزونه');
        }

        ?>
        <div class="wrap" style="margin:5px;">
            <?php
            $this->showTabs($defaultTab);
            $header='';
            switch ($tab) {
                case IRPP_TAB_SETTINGS:
                    $header='Settings';
                    break;
                case IRPP_TAB_WHATS_NEW:
                    $header='';
                    break;
            }

            if($irpp->Lang->H($header.'Title')) { ?>
                <h2><?php $irpp->Lang->P($header . 'Title', IRPP_PLUGIN_VERSION) ?></h2>
                <?php if ($irpp->Lang->H($header . 'Subtitle')) { ?>
                    <div><?php $irpp->Lang->P($header . 'Subtitle') ?></div>
                <?php } ?>
                <div style="clear:both;"></div>
            <?php }

            if($tab!=IRPP_TAB_WHATS_NEW) {
                irpp_ui_first_time();
                if($message!='') {
                    $irpp->Options->pushMessage($success, $message, $licenseKey);
                    $irpp->Options->writeMessages();
                    $data=$irpp->Options->getLicense();
                    if($data!==FALSE) { ?>
                        <p style="border:1px dashed red; padding:10px;">
                            <b style="text-decoration: underline;">
                                <?php $irpp->Lang->P('GuruInfo') ?>
                            </b>
                            <?php foreach($data as $k=>$v) { ?>
                                <br/>
                                <b><?php echo $k?>:</b>&nbsp;<?php echo $v?>
                            <?php } ?>
                        </p>
                    <?php }
                }
            }

            switch ($tab) {
                case IRPP_TAB_SETTINGS:
                    irpp_ui_settings();
                    break;
                case IRPP_TAB_WHATS_NEW:
                    irpp_ui_whats_new();
                    break;
            }

            if($irpp->Options->isShowWhatsNew()) {
                $irpp->Options->setShowWhatsNew(FALSE);
            }
            ?>
        </div>
    <?php }

    function showTabs($defaultTab) {
        global $irpp;
        $tab=$irpp->Check->of('tab', $defaultTab);
        if($tab==IRPP_TAB_DOCS) {
            $irpp->Utils->redirect(IRPP_TAB_DOCS_URI);
        }

        ?>
        <h2 class="nav-tab-wrapper" style="float:left; width:97%;">
            <?php
            foreach ($this->tabs as $k=>$v) {
                $active = ($tab==$k ? 'nav-tab-active' : '');
                ?>
                <a style="float:left; margin-left:10px;" class="nav-tab <?php echo $active?>" href="?page=<?php echo IRPP_PLUGIN_SLUG?>&tab=<?php echo $k?>"><?php echo $v?></a>
            <?php
            }
            ?>
            <style>
                .starrr {display:inline-block}
                .starrr i{font-size:16px;padding:0 1px;cursor:pointer;color:#2ea2cc;}
            </style>
            <div style="float:right; display:none;" id="rate-box">
                <span style="font-weight:700; font-size:13px; color:#555;"><?php $irpp->Lang->P('Rate us')?></span>
                <div id="irpp-rate" class="starrr" data-connected-input="irpp-rate-rank"></div>
                <input type="hidden" id="irpp-rate-rank" name="irpp-rate-rank" value="5" />
                <?php  $irpp->Utils->twitter('intellywp') ?>
            </div>
            <script>
                jQuery(function() {
                    jQuery(".starrr").starrr();
                    jQuery('#irpp-rate').on('starrr:change', function(e, value){
                        var url='https://wordpress.org/support/view/plugin-reviews/<?php echo IRPP_PLUGIN_SLUG?>?rate=5#postform';
                        window.open(url);
                    });
                    jQuery('#rate-box').show();
                });
            </script>
        </h2>
        <div style="clear:both;"></div>
    <?php }
}
