(function($) {
    var mi, ts, tool, options, newTool = true,
        globalOptions = '', globalMobileOptions = '', toolId,
        globalMagicScrollOptions = '',
        lockFlag = false,
        isCustomOptions = false,
        isCustomScrollOptions = false,
        shortcodeAjax = null,
        shortcodeTimer = null,
        nameNode,
        shortcodeNode,
        defImgSizeNode,
        thumbImgSizeNode,
        saveButtonNodes,
        saveAndCloseButtonNodes,
        closeButtonNodes,
        // lockButtonNodes,
        refrashButtonNode,
        d_iWidthNode, d_iHeightNode, t_iWidthNode, t_iHeightNode,
        thumbnailPositionNode,
        thumbnailModeNode,
        activatedLink,
        defaultRadio,
        customRadio,
        defaultScrollRadio,
        customScrollRadio,
        errorNodes = {};

    function capitalizeFirstLetter(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }

    function getThumbnailSizes () {
        var result = [];

        thumbImgSizeNode.find('option').each(function(i, o) {
            result.push($(o).val());
        });

        return result;
    }

    function getName() {
        var n = nameNode.val();
        if ('' === $.trim(n)) {
            errorNodes.name.css('display', 'inline-block');
            nameNode.addClass('its-error');
            n = null;
        }
        return n;
    }

    function shortcodeIsValid(str) {
        if ('' === $.trim(str)) { return true; }
        //return /^[A-Za-z][A-Za-z0-9_-]*$/.test(str);
        return /^[A-Za-z0-9_\-]*$/.test(str);
    }

    function getShortCode() {
        var n = $.trim(shortcodeNode.val());

        if (!shortcodeIsValid(n)) {
            errorNodes.shortcode.css('display', 'inline-block');
            shortcodeNode.addClass('its-error');
            n = null;
        }

        return n;
    }

    function lock(unlock) {
        lockFlag = !unlock;

        $.each([
            nameNode,
            shortcodeNode,
            defImgSizeNode,
            thumbImgSizeNode,

            d_iWidthNode,
            d_iHeightNode,
            t_iWidthNode,
            t_iHeightNode,

            saveButtonNodes,
            saveAndCloseButtonNodes,

            defaultRadio,
            customRadio,

            refrashButtonNode
        ], function(i, n) {
            n.prop('disabled', lockFlag);
        });

        mi.lock();
        ts.lock();

        if (isCustomOptions) {
            options.lock();
        }
    }

    function getAdditionalOptions() {
        var result = '', size, w, h;

        size = defImgSizeNode.val();
        w = d_iWidthNode.val();
        h = d_iHeightNode.val();

        if ('custom' == size) {
            if (parseInt(w) <= 0 || parseInt(h) <= 0) {
                size = 'medium';
            }
        }

        result += ( 'image_size:' + size + ';' );
        result += ( 'image_width:' + w + ';' );
        result += ( 'image_height:' + h + ';' );


        size = thumbImgSizeNode.val();
        w = t_iWidthNode.val();
        h = t_iHeightNode.val();

        if ('custom' == size) {
            if (parseInt(w) <= 0 || parseInt(h) <= 0) {
                size = 'thumbnail';
            }
        }

        result += ( 'thumbnail_size:' + size + ';' );
        result += ( 'thumbnail_width:' + w + ';' );
        result += ( 'thumbnail_height:' + h + ';' );
        result += ( 'thumbnails_position:' + thumbnailPositionNode.val() + ';' );

        result += ( 'settings:' + (isCustomOptions ? 'custom' : 'default') + ';' );

        result += ( 'gallery_mode:' + (mi.img ? false : true) + ';' );

        if (thumbnailModeNode.length) {
            result += ( 'thumbnail_mode:' + thumbnailModeNode.val() + ';' );
            result += ( 'scrollsettings:' + (isCustomScrollOptions ? 'custom' : 'default') + ';' );
        }

        return result;
    }

    function parseOptions(str) {
        var result = {}, k, v;
        str = str.split(";");

        $.each(str, function(i, v) {
            var value = $.trim(v);
            if ('' !== value) {
                value = value.split(':');
                k = value.shift();
                v = value.join(':');
                if ('cssClass' == k) {
                    if ('dark' == v) {
                        v = 'dark-bg';
                    } else if ('white' == v) {
                        v = 'white-bg';
                    } else {
                        v = 'blurred';
                    }
                }
                // result[$.trim(value[0])] = $.trim(value[1]);
                result[$.trim(k)] = $.trim(v);
            }
        });
        return result;
    }

    function save(callback) {
        var _id, _name,
            _shortcode,
            _image, _thumbnails,
            _options, _mobileOptions,
            _scrollOptions,
            _additional_options;

        _name = getName();
        _shortcode = getShortCode();

        if (null === _name || null === _shortcode) {
            callback('parameters_are_invalid');
            return;
        }

        _image = '';
        _thumbnails = ts.getData();

        _image = mi.imgId;

        if (null === _image && (!_thumbnails || '' == $.trim(_thumbnails))) {
            errorNodes.defImage.css('display', 'block');
            errorNodes.thumbnailsImages.css('display', 'block');
            callback('parameters_are_invalid');
            return;
        }

        if (null === _image) {
            _image = '';
        }

        _id = toolId;
        _image += '';
        _options = options.getString(false, true, false, ts.isWithVideo());
        _mobileOptions = options.getString(true, true, false, ts.isWithVideo());
        _additional_options = getAdditionalOptions();

        _scrollOptions = $.trim(options.getScrollString(true));
        if (_scrollOptions !== '') {
            _options = _options + '|' + _scrollOptions;
        }


        saveButtonNodes.parent().addClass('loading');

        lock();

        $.post(magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.ajax, {
            action: "WordPress_MagicZoomPlus_save",
            nonce: magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.nonce,
            id: _id,
            name: _name,
            shortcode: _shortcode,
            image: _image,
            thumbnails: _thumbnails,
            options: _options, // 'default' || json
            mobile_options: _mobileOptions, // 'default' || json
            additional_options: _additional_options
        })
        .success(function(_data) {
            _data = JSON.parse(_data);
            callback(null, _data);
        })
        .error(function(e) { callback(e); });
    }

    function createVideoManagerWindow(callback) {
        function _createNode(_class, tag) {
            if (!tag) { tag = 'div'; }
            var n = $('<' + tag + '>');
            if (_class) { n.addClass(_class); }
            return n;
        }

        function getVideoSize(node) {
            var w = node.width(), h = node.height();

            if (w > h) { w = h * (16 / 9); }
            else { h = w * (9 / 16); }
            
            return { width: w, height: h };
        }

        function checkStr(str) { return /vimeo|youtu/.test(str); }

        var lastInputValue = '';

        var mainContainer = _createNode('video-manager-container'),
            curtain = _createNode('vm-curtain'),
            container = _createNode('vm-container'),
            wrapper = _createNode('vm-wrapper'),
            body = _createNode('vm-body'),
            top = _createNode('vm-top'),
            input = _createNode(null, 'input'),
            bottom = _createNode('vm-bottom');
            iframeContainer = _createNode('vm-iframe-container'),
            helper = _createNode('vm-helper', 'span').text('?'),
            iframeLoader = _createNode('vm-iframe-loader'),
            controlPanel = _createNode('vm-control-panel'),
            no = _createNode('button', 'button').text('Cancel'),
            ok = _createNode('button button-primary', 'button').text('Add');

        helper.css({'white-space': 'pre'}); // for new lines content
        helper.attr('magic-tooltip', 'Video url formats:\nhttps://www.youtube.com/watch?v=***video id***\nhttps://youtu.be/***video id***\nhttps://player.vimeo.com/video/***video id***');
        helper.attr('magic-tooltip-position', 'left');

        curtain.on('click', function (e) {
            e.stopPropagation();
            e.preventDefault();
            mainContainer.remove();
            callback(null);
        });

        no.on('click', function (e) {
            e.stopPropagation();
            e.preventDefault();
            curtain.off('click');
            no.off('click');
            ok.off('click');
            mainContainer.remove();
            callback(null);
        });
        
        ok.prop('disabled', true);
        ok.on('click', function (e) {
            e.stopPropagation();
            e.preventDefault();
            mainContainer.remove();
            callback(correctYotubeSrc(lastInputValue));
        });

        var iframeTimer = null;
        var loaderTimer = null;

        function getYouTobeId(url) {
            var result = null;

            url = url.replace(/(>|<)/gi,'').split(/(vi\/|v=|\/v\/|youtu\.be\/|\/embed\/)/);
            if(url[2] !== undefined) {
                url = url[2].split(/[^0-9a-z_\-]/i);
                if (url.length && url[0]) {
                    result = url[0];
                }
            }

            return result;
        }

        function getVimeoId(url) {
            var result = null;

            url = url.match(/(?:https?:\/\/)?(?:www.)?(?:player.)?vimeo.com\/(?:[a-z]*\/)*([0-9]{6,11})[?]?.*/)[1];
            if (url) { result = url; }

            return result;
        }

        function correctYotubeSrc(url) {
            if (/youtube.com\/watch/.test(url) || /youtu\.be/.test(url)) {
                url = 'https://www.youtube.com/embed/' + getYouTobeId(url);
            } else if (/vimeo/.test(url) && !/player\.vimeo\.com/.test(url)) {
                if (getVimeoId(url)) {
                    url = 'https://player.vimeo.com/video/' + getVimeoId(url);
                }
            }

            return url;
        }

        function loadIframe() {
            clearTimeout(iframeTimer);
            iframeTimer = setTimeout(function () {
                iframeContainer.html('');

                ok.prop('disabled', true);
                loaderTimer = setTimeout(function() {
                    iframeContainer.append(iframeLoader);
                }, 300);

                var size = getVideoSize(iframeContainer);
                var iframe = $('<iframe src="' + correctYotubeSrc(lastInputValue) + '" width="' + size.width + '" height="' + size.height + '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>');

                iframe.css({ opacity: 0 });
                iframe.on('load', function() {
                    clearTimeout(loaderTimer);
                    iframeLoader.remove();
                    iframe.css({ opacity: 1 });
                    ok.prop('disabled', false);
                });

                iframe.css({
                    width: size.width + 'px',
                    height: size.height + 'px'
                });

                iframeContainer.append(iframe);
            }, 300);
        }

        input.on('keyup', function (e) {
            e.stopPropagation();
            e.preventDefault();
            ok.prop('disabled', true);
            if (lastInputValue !== $.trim(input.val())) {
                lastInputValue = $.trim(input.val());
                if (checkStr(lastInputValue)) { loadIframe(); }
            }
        });

        mainContainer.append(curtain);

        top.append(_createNode().append(_createNode().text('Add Vimeo or Youtube url')).append(_createNode().append(input).append(helper)));

        bottom.append(iframeContainer);

        body.append(top);
        body.append(bottom);

        controlPanel.append(_createNode().append(no).append(ok))

        wrapper.append(body);
        wrapper.append(controlPanel);

        container.append(wrapper);
        mainContainer.append(container);

        $(document.body).append(mainContainer);
    }

    function Option(trNode) {
        this.node = trNode;
        
        this.buttonOfState = this.node.find('button');
        this.actionNode = this.node.find('input');

        if (!this.actionNode.length) {
            this.actionNode = this.node.find('select');
        }

        this.defaultValue = this.actionNode.val();

        this.isSwitchControl = this.actionNode.attr('type') === 'checkbox';

        this.setEvents();
    }

    $.extend(Option.prototype, {
        setDefaultValue: function (value) {
            this.defaultValue = value;
        },

        getState: function () {
            return this.actionNode.attr('data-state');
        },

        getName: function () {
            return this.actionNode.attr('name');
        },

        isMobile: function () {
            return this.actionNode[0].hasAttribute('data-mobile');
        },

        changeState: function () {
            if (this.buttonOfState.hasClass('dashicons-lock')) {
                this.node.removeClass('disabled-option');

                this.buttonOfState
                    .removeClass('dashicons-lock')
                    .addClass('dashicons-unlock')
                    .attr('title', 'Lock');

                this.actionNode
                    .prop('disabled', false)
                    .attr('data-state', 'unlock');

            } else {
                this.node.addClass('disabled-option');

                this.buttonOfState
                    .removeClass('dashicons-unlock')
                    .addClass('dashicons-lock')
                    .attr('title', 'Unlock');

                this.actionNode
                    .prop('disabled', true)
                    .attr('data-state', 'lock');

                if (this.isSwitchControl) {
                    this.actionNode.prop('checked', this.defaultValue === 'Yes');
                }

                this.actionNode.val(this.defaultValue);
            }
        },

        setEvents: function () {
            var self = this;

            this.buttonOfState.on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                self.changeState();
            });

            if (this.isSwitchControl) {
                this.actionNode.on('change', function () {
                    if (self.actionNode.prop('checked')) {
                        self.actionNode.val('Yes');
                    } else {
                        self.actionNode.val('No');
                    }
                });
            }
        },

        getValue: function (correct, defaultValue) {
            var value = defaultValue ? this.defaultValue : this.actionNode.val();

            if (correct) {
                if (value === 'Yes' || value === 'No') {
                    value = (value === 'Yes');
                }
            }

            return value;
        },

        setvalue: function (value) {
            this.actionNode.val(value);
        }
    });

    function Options() {
        this.container = $('#custom-options-container');

        this.options = {};
        this.mobileOptions = {};

        this.scrollContainer = $('#magicscroll-custom-options');
        this.scrollOptions = {};

        this.parse();
    }

    $.extend(Options.prototype, {
        parse: function () {
            var self = this;

            $.each(this.container.find('tbody').find('tr:not(.caption)'), function (index, node) {
                var option = new Option($(node)),
                    name = option.getName();

                if (option.isMobile()) {
                    option.setDefaultValue(globalMobileOptions[name]);
                    self.mobileOptions[name] = option;
                } else {
                    option.setDefaultValue(globalOptions[name]);
                    self.options[name] = option;
                }
            });

            if (this.scrollContainer.length) {
                $.each(this.scrollContainer.find('tr'), function (index, node) {
                    var option = new Option($(node)),
                        name = option.getName();

                    option.setDefaultValue(globalMagicScrollOptions[name]);
                    self.scrollOptions[name] = option;
                });
            }
        },

        getJSON: function(isMobile, save, isWithVideo) {
            var opt = {}, name, state, _save = false,
                options = this.options;

            if (isMobile) { options = this.mobileOptions; }

            $.each(options, function (name, option) {
                state = option.getState();


                if (isCustomOptions && state !== 'lock' || _save) {
                    opt[name] = option.getValue(!save);
                } else if (!save) {
                    opt[name] = option.getValue(true, true);
                }
            });

            if (isWithVideo) { opt['transitionEffect'] = false; }

            return opt;
        },

        getString: function(isMobile, save, toolOnly, isWithVideo, additionalOptions) {
            var opt = '', separator = save ? '' : ' ';

            if (!additionalOptions) { additionalOptions = {}; }

            $.each($.extend(this.getJSON(isMobile, save, isWithVideo), additionalOptions), function(k, v) {
                var write = true;
                if (toolOnly) {
                    if (k === 'background') {
                        write = false;
                    }
                }
                if (write) {
                    opt += (k + ':' + separator + v + ';' + separator);
                }
            });

            //opt += ('captionSource:' + separator + 'title;' + separator);

            return opt;
        },

        getScrollJSON: function (save) {
            var opt = { orientation: 'horizontal' }, state, thumbPos = thumbnailPositionNode.val();

            $.each(this.scrollOptions, function (name, option) {
                state = option.getState();

                if (isCustomScrollOptions && state !== 'lock') {
                    opt[name] = option.getValue(!save);
                } else if (!save) {
                    opt[name] = option.getValue(true, true);
                }
            });

            if (thumbPos === 'left' || thumbPos === 'right') { opt.orientation = 'vertical'; }

            return opt;
        },

        getScrollString: function (save) {
            var opt = '', separator = save ? '' : ' ';

            $.each(this.getScrollJSON(save), function(k, v) {
                opt += (k + ':' + separator + v + ';' + separator);
            });

            return opt;
        },

        lock: function () {
        //         var _lock = function(arr) {
        //             $.each(arr, function(i, el) {
        //                 el = $(el);
        //                 if ('lock' !== el.attr('data-state')) {
        //                     el.prop('disabled', lockFlag);
        //                 }
        //             });
        //         };

        //         _lock(this.selects);
        //         _lock(this.inputs);
        //         _lock(this.mobSelects);
        //         _lock(this.mobInputs);
        }
    });

    function Tool() {
        var self = this;

        this.toolId = 'MagicZoomPlus-constructor';
        this.container = $('.tool-container');

        refrashButtonNode.on('click', function(e) {
            self.setTool();
        });
    }

    $.extend(Tool.prototype, {
        clean: function() {
            var mTool = window['MagicZoom'];
            if (mTool) { mTool.stop(); }
            var additionalTool = window.MagicScroll;
            if (additionalTool) {
                additionalTool.stop();
            }
            this.container[0].innerHTML = '';
        },
        createStyle: function(nameOfStyle, value) {
            var result = null;
            if (value && '' !== $.trim(value)) {
                result = "";
                result += "<style type='text/css'> ";
                result += ".mz-expand .mz-expand-bg { display: none !important; } ";
                result += ".mz-expand { " + nameOfStyle + ": " + value + "; }";
                result += "</style>";
                result = $(result);
            }
            return result;
        },
        getVideoThumbs: function (arr) {
            var result = [];
            $(arr).each(function(i, a) {
                if ($(a).attr('data-video-id')) { result.push(a); }
            });
            return result;
        },

        setTool: function() {
            var self = this,
                mTool = window['MagicZoom'],
                withVideo = ts && ts.isWithVideo();

            var additionalTool = window.MagicScroll;

            refrashButtonNode.prop('disabled', true);
            refrashButtonNode.addClass('loading');

            this.getDeafImgNode(withVideo, function(dNode) {
                self.getThumbImgNodes(function(tNode) {
                    var thumbPos, mainContainer, videoContainers = [],
                        defImgContainer, thumbImgWrapper, thumbImgContainer;

                    if (mi.img) {
                        if (dNode) {
                            $('.MagicToolboxContainer').MagicToolboxGalleryDestroy();
                            if (mTool) { mTool.stop(); }
                            if (additionalTool) { additionalTool.stop(); }

                            self.container[0].innerHTML = '';
                            thumbPos = thumbnailPositionNode.val();

                            mainContainer = $('<div>');

                            mainContainer.addClass('MagicToolboxContainer');
                            mainContainer.addClass('minWidth');

                            if (thumbnailModeNode.val() !== 'scroll' || !additionalTool) {
                                mainContainer.addClass('noscroll');
                            }

                            style = self.createStyle('background-color', options.getJSON()['background']);
                            if (style) {
                                mainContainer.append(style);
                            }
                            if (withVideo) {
                                mainContainer.addClass('MagicToolboxGallery');
                                $(self.getVideoThumbs(tNode)).each(function (i, a) {
                                    videoContainers.push($('<div>').append($('<iframe id="' + a.attr('data-video-id') + '" src="' + a.attr('data-video-url') + '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>')));
                                });
                            }

                            function addVideoContainers (_container) {
                                if (videoContainers.length) {
                                    $(videoContainers).each(function (i, c) {
                                        _container.append(c);
                                    });
                                }
                            }

                            if ('right' === thumbPos || 'left' === thumbPos) {
                                defImgContainer = $('<div>');
                                defImgContainer.addClass('MagicToolboxMainContainer');
                                if (withVideo) {
                                    defImgContainer.append($('<div>').append(dNode));
                                    // addVideoContainers(defImgContainer);
                                } else {
                                    defImgContainer.append(dNode);
                                }
                            } else {
                                defImgContainer = dNode;
                                if (withVideo) {
                                    defImgContainer = $('<div>').append(defImgContainer);
                                }
                            }

                            if (tNode.length) {
                                mainContainer.addClass('selectors' + capitalizeFirstLetter(thumbPos));

                                thumbImgWrapper = $('<div>');
                                thumbImgWrapper.addClass('MagicToolboxSelectorsContainer');
                                if ('left' === thumbPos || 'right' === thumbPos) {
                                    thumbImgWrapper.css('width', ts.getWidth() + 'px');
                                }

                                thumbImgContainer = $('<div>');
                                if (thumbnailModeNode.length && thumbnailModeNode.val() === 'scroll' && additionalTool) {
                                    thumbImgContainer.addClass('MagicScroll');
                                    thumbImgContainer.attr('data-options', options.getScrollString());
                                }
                                thumbImgWrapper.append(thumbImgContainer);

                                $.each(tNode, function(i, n) {
                                    thumbImgContainer.append(n);
                                });

                                if ('left' === thumbPos || 'top' === thumbPos) {
                                    mainContainer.append(thumbImgWrapper);
                                }
                            }

                            if ('left' === thumbPos || 'top' === thumbPos) {
                                if (tNode.length) {
                                    // mainContainer.append(thumbImgWrapper);
                                    mainContainer.append(thumbImgWrapper);
                                }
                                mainContainer.append(defImgContainer);
                                if ('left' === thumbPos) {
                                    addVideoContainers(defImgContainer);
                                } else {
                                    addVideoContainers(mainContainer);
                                }
                            } else {
                                mainContainer.append(defImgContainer);
                                if ('right' === thumbPos) {
                                    addVideoContainers(defImgContainer);
                                } else {
                                    addVideoContainers(mainContainer);
                                }
                                if (tNode.length) {
                                    mainContainer.append(thumbImgWrapper);
                                }
                            }

                            // mainContainer.append(defImgContainer);

                            // if (tNode.length && ('right' === thumbPos || 'bottom' === thumbPos)) {
                            //     // defImgContainer.append(thumbImgWrapper);
                            //     mainContainer.append(thumbImgWrapper);
                            // }

                            self.container.append(mainContainer);

                            if (mTool) {
                                if (withVideo) {
                                    mainContainer.MagicToolboxGallery();
                                }
                                if (additionalTool) { additionalTool.start(); }
                                mTool.start(self.toolId);
                            }
                        }
                    } else {
                        $('.MagicToolboxContainer').MagicToolboxGalleryDestroy();
                        if (mTool) { mTool.stop(); }
                        self.container[0].innerHTML = '';

                        mainContainer = $('<div>');

                        mainContainer.addClass('MagicToolboxContainer');
                        mainContainer.addClass('minWidth');
                        mainContainer.addClass('noscroll');

                        style = self.createStyle('background-color', options.getJSON()['background']);
                        if (style) {
                            mainContainer.append(style);
                        }

                        if (tNode.length) {
                            // mainContainer.addClass('selectors' + capitalizeFirstLetter(thumbPos));

                            thumbImgWrapper = $('<div>');
                            thumbImgWrapper.addClass('MagicToolboxSelectorsContainer');
                            // if ('left' === thumbPos || 'right' === thumbPos) {
                            //     thumbImgWrapper.css('width', ts.getWidth() + 'px');
                            // }
                            thumbImgContainer = $('<div>');
                            thumbImgWrapper.append(thumbImgContainer);

                            $.each(tNode, function(i, n) {
                                thumbImgContainer.append(n);
                            });

                            mainContainer.append(thumbImgWrapper);
                        }

                        self.container.append(mainContainer);

                        if (mTool) { mTool.start(); }
                    }

                    refrashButtonNode.prop('disabled', false);
                    refrashButtonNode.removeClass('loading');
                });
            });
        },

        getDeafImgNode: function(withVideo, callback) {
            var self = this;

            if (mi && !$(this).prop("checked")) {
                mi.getUrl(function(err, urls) {
                    var node;
                    if (err) {
                        callback(null);
                    } else {
                        if (urls) {
                            node = $('<a>')
                                .addClass('MagicZoom')
                                .attr('href', urls.origin)
                                .attr('title', urls.title)
                                .attr('id', self.toolId)
                                .attr('data-options', options.getString(false, false, true, withVideo))
                                .attr('data-mobile-options', options.getString(true, false, true, withVideo));

                            node.append($('<img>').attr('src', urls.medium).attr('alt', urls.alt));

                            callback(node);
                        } else {
                            callback(null);
                        }
                    }
                });
            } else {
                callback(null);
            }
        },

        getThumbImgNodes: function(callback) {
            var load, self = this,
                images = [], loaded = 0;

            if (ts) {
                ts.getUrls(function(err, result) {
                    var tNode, imgSrc, imgCss = {};
                    if (err) {
                        callback(null);
                    } else {
                        $.each(result, function(i, thumb) {
                            if (mi.img) {
                                tNode = $('<a>');
                                tNode.attr('title', thumb.title)
                                    .attr('href', thumb.origin)
                                    .attr('data-image', thumb.medium);

                                if (thumb.type === 'video') {
                                    tNode.attr('data-video-id', 'video-'+ thumb.id);
                                    tNode.attr('data-video-url', thumb.video);
                                    tNode.addClass('shortcode-video-selector');

                                    var w = parseInt(ts.getWidth());
                                    var h = parseInt(ts.getHeight());

                                    imgCss = { 'max-width': w + 'px', 'max-height': h + 'px' };

                                    if (w > thumb.thumbSize.width) {
                                        imgSrc = thumb.medium;
                                    } else {
                                        imgSrc = thumb.thumbnail;
                                    }
                                } else {
                                    tNode.attr('data-zoom-id', self.toolId);
                                    imgSrc = thumb.thumbnail;
                                }

                                tNode.append($('<img>').attr('src', imgSrc).attr('alt', thumb.alt).css(imgCss));
                            } else {
                                if (thumb.type === 'video') { return; }

                                tNode = $('<a>')
                                    .addClass('MagicZoom')
                                    .attr('data-gallery', self.toolId)
                                    .attr('href', thumb.origin)
                                    .attr('title', thumb.title)
                                    .attr('id', 'MagicZoomPlus-' + i)
                                    .attr('data-options', options.getString(false, false, true, false))
                                    .attr('data-mobile-options', options.getString(true, false, true, false));

                                tNode.append($('<img>').attr('src', thumb.thumbnail).attr('alt', thumb.alt));

                            }

                            images.push(tNode);
                        });

                        callback(images);
                    }
                });
            } else {
                callback(null);
            }
        }
    });

    function ImageLoader(src, callback) {
        var container = $('<div>'),
            img = $('<img>', {}, {'max-width': 'none', 'max-height': 'none'});

        img.attr('src', src);

        container.css({
            'top': '-100000px',
            'left': '-100000px',
            'width': '10px',
            'height': '10px',
            'position': 'absolute',
            'overflow': 'hidden'
        }).append(img);

        img.on('load', function() {
            callback(null, { url: src, size: { width: img.width(), height: img.height()} });
            container.remove();
        });

        img.on('error', function() {
            callback(src);
            container.remove();
        });

        container.appendTo(document.body);
    }

    function MainImage() {
        var self = this,
            button = $('#main-image-button');

        this.node = $('#tool-image');
        this.imgId = null;
        this.url = null;
        this.isLoading = false;
        this.timer = false;
        this.imgData = null;
        this.button = button;
        this.img = null;
        this.addButton = $('#add-main-image-button');

        this.chooseImgEvent = function(e) {
            var wp_media;

            errorNodes.defImage.css('display', '');
            errorNodes.thumbnailsImages.css('display', '');
            errorNodes.loadImage.css('display', '');

            if (self.isLoading || lockFlag) { return; }

            wp_media = wp.media({
                title: 'Image for Magic Zoom Plus',
                library: { type: 'image' },
                multiple: false,
                button: { text: 'Select' }
            });

            wp_media.on('select', function() { self.load(wp_media.state().get('selection').toJSON()[0]); });
            wp_media.open();
        };

        this.addButton.on('click', this.chooseImgEvent);

        button.on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            if (lockFlag) { return; }
            self.imgId = null;
            self.url = null;
            self.imgData = null;
            if (self.img) {
                self.img.remove();
            }
            self.img = null;
            self.node.addClass('empty');
            if (ts) {
                // ts.bEnable(false);
                ts.setActive();
            }

            self.switchBtn();

            errorNodes.defImage.css('display', '');
            errorNodes.thumbnailsImages.css('display', '');
            errorNodes.loadImage.css('display', '');

            if (!ts.images.length) {
                refrashButtonNode.css('display', 'none');
            }

            tool.clean();
        });
    }

    $.extend(MainImage.prototype, {
        switchBtn: function(hide) {
            if (hide) {
                this.addButton.css('display', 'none');
                this.node.parent().on('click', this.chooseImgEvent);
            } else {
                this.addButton.css('display', '');
                this.node.parent().off('click', this.chooseImgEvent);
            }
        },
        load: function(img, callback) {
            var self = this, url;

            img || (img = window.main_image);

            if ('' === img.url) {
                if (callback) {
                    callback();
                }
                return;
            }

            this.node.removeClass('empty');

            this.isLoading = true;

            if (ts) {
                ts.bEnable();
            }

            if (this.url) {
                this.img.remove();
            }

            this.switchBtn(true);

            saveButtonNodes.prop('disabled', true);
            saveAndCloseButtonNodes.prop('disabled', true);

            this.timer = setTimeout(function() {
                clearTimeout(self.timer);
                self.node.addClass('loading');
            }, 250);

            url = img.sizes.medium ? img.sizes.medium.url : img.sizes.full.url;

            new ImageLoader(url, function(err, result) {
                self.isLoading = false;
                clearTimeout(self.timer);
                self.node.removeClass('loading');
                if (err) {
                    if (!self.url) {
                        self.node.addClass('empty');
                    }
                    errorNodes.loadImage.css('display', 'block');
                    // refrashButtonNode.css('display', 'none');
                } else {
                    self.imgData = img;
                    self.imgData.sizes['origin'] = { url: img.url };
                    self.imgId = img.id;
                    self.url = url;
                    self.img = $('<img>').attr('src', self.url);
                    self.node.append(self.img);
                    if (ts) {
                        ts.bEnable(true);
                        ts.setActive();
                    }
                }
                saveButtonNodes.prop('disabled', false);
                saveAndCloseButtonNodes.prop('disabled', false);
                refrashButtonNode.css('display', 'inline-block');
                // tool.setTool();
                if (callback) {
                    callback();
                }
            });
        },

        lock: function() {
            this.button.prop('disabled', lockFlag);
        },

        isLoaded: function(size) {
            return this.imgData.sizes[size]
        },

        _getUrlFromServer: function(id, size, callback) {
            var self = this,
                sizeName = $.isArray(size) ? (size[0] + 'x' + size[1]) : size;

            if (!this.imgData.sizes[sizeName]) {
                getUrlFromServer([{id: id, sizes: { medium: size }}], function(err, result) {
                    if (err) {
                        callback(err);
                    } else {
                        self.imgData.sizes[sizeName] = { url: result[0].medium};
                        result.origin = self.imgData.sizes[sizeName].origin;
                        callback(null, result);
                    }
                });
            } else {
                callback(null, [{
                    medium: this.imgData.sizes[sizeName].url,
                    origin: this.imgData.sizes[sizeName].origin
                }]);
            }
        },

        getUrl: function(callback) {
            var self = this, w, h,
                size = defImgSizeNode.val(),
                sizeName = size;

            if ( 'custom' === size ) {
                w = d_iWidthNode.val();
                h = d_iHeightNode.val();
                if (parseInt(w) > 0 && parseInt(h) > 0) {
                    size = [w, h];
                    sizeName = size[0] + 'x' + size[1];
                } else {
                    size = 'medium';
                    sizeName = size;
                }
            }

            if (this.imgData) {
                this._getUrlFromServer(this.imgData.id, size, function(err, arr) {
                    if (err) {
                        callback(err);
                    } else {
                        if (!self.imgData.sizes[sizeName].loaded) {
                            new ImageLoader(arr[0].medium, function(err, result) {
                                if (err) {
                                    callback(err);
                                } else {
                                    self.imgData.sizes[sizeName].loaded = true;
                                    callback(null, {
                                        alt:    self.imgData.alt,
                                        title:  self.imgData.title,
                                        medium: self.imgData.sizes[sizeName].url,
                                        origin: self.imgData.sizes.origin.url
                                    });
                                }
                            });
                        } else {
                            callback(null, {
                                alt:    self.imgData.alt,
                                title:  self.imgData.title,
                                medium: self.imgData.sizes[sizeName].url,
                                origin: self.imgData.sizes.origin.url
                            });
                        }
                    }
                });
            } else {
                callback(null, null);
            }
        }
    });

    function getUrlFromServer(arr, callback) {
        $.post(magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.ajax, {
            action: "WordPress_MagicZoomPlus_get_img_urls",
            nonce: magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.nonce,
            ids: arr
        })
        .success(function(data) {
            data = JSON.parse(data);
            callback(data.error, data.urls);
        })
        .error(function(e) { callback(e); });
    }

    function Thumbnails() {
        var self = this;

        this.container = $('#thumbnails');
        this.addButton = $('#add-thumbnails-button');
        this.addVideoButton = $('#add-video-thumbnail-button');
        this.removeButton = $('#remove-thumbnails-button');
        this.imageWrapper = this.container.find('div.thumbnails-image-wrapper');
        this.imageWrapper.sortable({ // drag-and-drop
            revert: true,
            stop: function() {
                self.sortingAfterDragAndDrop()
            }
        });

        this.images = [];

        this.ImageClass = function(imgData, size) {
            var self = this,
                img = $('<img>'),
                rb = $('<button>');

            imgData.sizes['origin'] = { url: imgData.url };

            this.type = imgData.type;
            this.videoUrl = imgData.videoUrl;
            this.isDefault = false;
            this.imgData = imgData;
            //this.url = imgData.sizes.thumbnail.url;
            this.url = (imgData.sizes.thumbnail)?imgData.sizes.thumbnail.url:imgData.sizes[ Object.keys(imgData.sizes)[0] ].url;
            this.imgId = imgData.id;
            this.size = size;
            this.wrapper = $('<div>');
            this.radio = $('<div>').addClass('mt-radio').attr('title', 'Default image');
            this.imgCont = $('<div>').css({'position': 'relative'});

            rb.addClass('remove');

            this.wrapper.addClass('thumbnail-img');

            if (this.type === 'video') {
                this.wrapper.addClass('thumbnail-video');
            }

            img
                .attr('src', this.url)
                .attr('data-id', this.imgId);

            this.imgCont
                .append(img)
                .append(rb);

            this.wrapper.append(this.imgCont);

            rb.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (lockFlag) { return; }
                $(self).trigger('remove-thumbnail', { id: self.imgId });
            });
        };

        $.extend(this.ImageClass.prototype, {
            setActive: function() {
                if (mi && mi.imgData && mi.imgData.url === this.imgData.url) {
                    this.radio.appendTo(this.imgCont);
                } else {
                    this.radio.remove();
                }
            }
        });

        this.addButton.on('click', function(e) {
            var wp_media;

            if (lockFlag) { return; }

            wp_media = wp.media({
                title: 'Thumbnail images',
                library: { type: 'image' },
                multiple: true,
                button: { text: 'Select' }
            });

            wp_media.on('select', function() { self.load(wp_media.state().get('selection').toJSON()); });
            wp_media.open();
        });

        this.addVideoButton.on('click', function(e) {
            if (lockFlag) { return; }
            createVideoManagerWindow(function(videoUrl) {
                self.getVideoImage(videoUrl, function (obj) {
                    if (obj) { self.load([obj]); }
                });
            });
        });

        this.removeButton.on('click', function(e) {
            if (lockFlag) { return; }
            self.removeImage();
            // tool.setTool();
        });
    }

    $.extend(Thumbnails.prototype, {
        sortingAfterDragAndDrop: function() {
            var self = this, arr = [];

            function getImagePerId(id, _arr) {
                var i, l = _arr.length;

                id = parseInt(id);

                for (i = 0; i < l; i++) {
                    if (_arr[i].imgId === id) {
                        return _arr[i];
                    }
                }
            }

            $.each(this.imageWrapper.children(), function(index, child) {
                var dataId = $(child).find('img').attr('data-id');
                arr.push(getImagePerId(dataId, self.images));
            });

            this.images = arr;
        },

        getWidth: function() {
            var typeOfSize = thumbImgSizeNode.val();
            if ('custom' === typeOfSize) {
                return t_iWidthNode.val();
            } else {
                return this.images[0].imgData.sizes[typeOfSize].width;
            }
        },

        getHeight: function() {
            var typeOfSize = thumbImgSizeNode.val();
            if ('custom' === typeOfSize) {
                return t_iHeightNode.val();
            } else {
                return this.images[0].imgData.sizes[typeOfSize].height;
            }
        },

        getImg: function(id) {
            for (var i = 0; i < this.images.length; i++) {
                if (this.images[i].imgData.id === id) {
                    return this.images[i];
                }
            }
            return null;
        },

        isWithVideo: function() {
            var result = false;

            for (var i = 0; i < this.images.length; i++) {
                if (this.images[i].type === 'video') {
                    result = true;
                    break;
                }
            }

            return result;
        },

        _getUrlFromServer: function(size, defSize, callback) {
            var self = this,
                thumbSizeName = $.isArray(size) ? (size[0] + 'x' + size[1]) : size,
                defSizeName = $.isArray(defSize) ? (defSize[0] + 'x' + defSize[1]) : defSize,
                data = [],
                getVideoImage = function (imgObj) {
                    var result = null, w, h;

                    if (imgObj.type === 'video') {
                        w = parseInt(self.getWidth());
                        h = parseInt(self.getHeight());

                        if (w > imgObj.imgData.sizes.thumbnail.width) {
                            result = imgObj.imgData.sizes.medium.url;
                        } else {
                            result = imgObj.imgData.sizes.thumbnail.url;
                        }
                    }

                    return result;
                };

            $.each(this.images, function(i, img) {
                var _sizes = {};
                if ((!img.imgData.sizes[thumbSizeName] || !img.imgData.sizes[defSizeName]) && img.type !== 'video') {
                    if (!img.imgData.sizes[thumbSizeName]) {
                        _sizes.thumbnail = size;
                    }
                    if (!img.imgData.sizes[defSizeName]) {
                        _sizes.medium = defSize;
                    }
                    data.push({
                        id: img.imgData.id,
                        alt: img.imgData.alt,
                        title: img.imgData.title,
                        sizes: _sizes
                    });
                }
            });

            if (data.length) {
                getUrlFromServer(data, function(err, result) {
                    var arr = [];
                    if (err) {
                        callback(err);
                    } else {
                        $.each(result, function(i, img) {
                            var _img = self.getImg(parseInt(img.id));
                            if (img.thumbnail && '' !== $.trim(img.thumbnail)) {
                                _img.imgData.sizes[thumbSizeName] = { url: img.thumbnail };
                            }

                            if (img.medium && '' !== $.trim(img.medium)) {
                                _img.imgData.sizes[defSizeName] = { url: img.medium };
                            }
                        });

                        $.each(self.images, function(i, img) {
                            var tmp;
                            if (img.type === "video") {
                                if (!img.imgData.sizes[thumbSizeName]) {
                                    tmp = {
                                        url: img.imgData.sizes.thumbnail.url,
                                        width: img.imgData.sizes.thumbnail.width,
                                        height: img.imgData.sizes.thumbnail.height
                                    };

                                    if ($.isArray(size)) {
                                        if (parseInt(size[0]) > img.imgData.sizes.thumbnail.width) {
                                            tmp.url = img.imgData.sizes.medium.url;
                                            tmp.width = img.imgData.sizes.medium.width,
                                            tmp.height = img.imgData.sizes.medium.height
                                        }
                                    }

                                    img.imgData.sizes[thumbSizeName] = tmp;
                                }
                                
                                if (!img.imgData.sizes[defSizeName]) {
                                    img.imgData.sizes[defSizeName] = {
                                        url: img.imgData.sizes.medium.url,
                                        width: img.imgData.sizes.medium.width,
                                        height: img.imgData.sizes.medium.height
                                    };
                                }
                            }

                            arr.push({
                                id: img.imgData.id,
                                alt: img.imgData.alt,
                                title: img.imgData.title,
                                thumbnail: img.imgData.sizes[thumbSizeName].url,
                                medium: img.imgData.sizes[defSizeName].url,
                                origin: img.imgData.sizes['origin'].url,
                                type: img.type,
                                video: img.videoUrl,
                                thumbSize: {
                                    width: img.imgData.sizes[thumbSizeName].width,
                                    height: img.imgData.sizes[thumbSizeName].height
                                }
                            })
                        });

                        callback(null, arr);
                    }
                });
            } else {
                var urls = [];
                $.each(this.images, function(i, img) {
                    if (img.type === "video") {
                        if (!img.imgData.sizes[thumbSizeName]) {

                            tmp = {
                                url: img.imgData.sizes.thumbnail.url,
                                width: img.imgData.sizes.thumbnail.width,
                                height: img.imgData.sizes.thumbnail.height
                            };

                            if ($.isArray(size)) {
                                if (parseInt(size[0]) > img.imgData.sizes.thumbnail.width) {
                                    tmp.url = img.imgData.sizes.medium.url;
                                    tmp.width = img.imgData.sizes.medium.width,
                                    tmp.height=  img.imgData.sizes.medium.height
                                }
                            }

                            img.imgData.sizes[thumbSizeName] = tmp;
                        }
                        
                        if (!img.imgData.sizes[defSizeName]) {
                            img.imgData.sizes[defSizeName] = {
                                url: img.imgData.sizes.medium.url,
                                width: img.imgData.sizes.medium.width,
                                height: img.imgData.sizes.medium.height
                            };
                        }
                    }
                    if (img.imgData.sizes[thumbSizeName] && img.imgData.sizes[defSizeName]) {
                        urls.push({
                            id: img.imgData.id,
                            alt: img.imgData.alt,
                            title: img.imgData.title,
                            thumbnail: img.imgData.sizes[thumbSizeName].url,
                            medium: img.imgData.sizes[defSizeName].url,
                            origin: img.imgData.sizes['origin'].url,
                            type: img.type,
                            video: img.videoUrl,
                            thumbSize: {
                                width: img.imgData.sizes[thumbSizeName].width,
                                height: img.imgData.sizes[thumbSizeName].height
                            }
                        });
                    }
                });

                callback(null, urls);
            }
        },

        getUrls: function(callback) {
            var self = this, w, h,
                defSize = defImgSizeNode.val(),
                defSizeName = size,
                size = thumbImgSizeNode.val(),
                sizeName = size;

            if (!this.images.length) {
                return callback(null, []);
            }

            if ( 'custom' === defSize ) {
                w = d_iWidthNode.val();
                h = d_iHeightNode.val();
                if (parseInt(w) > 0 && parseInt(h) > 0) {
                    defSize = [w, h];
                    defSizeName = defSize[0] + 'x' + defSize[1];
                } else {
                    defSize = 'medium';
                    defSizeName = defSize;
                }
            }

            if ( 'custom' === size ) {
                w = t_iWidthNode.val();
                h = t_iHeightNode.val();
                if (parseInt(w) > 0 && parseInt(h) > 0) {
                    size = [w, h];
                    sizeName = size[0] + 'x' + size[1];
                } else {
                    size = 'thumbnail';
                    sizeName = size;
                }
            }

            this._getUrlFromServer(size, defSize, function(err, arr) {
                if (err) {
                    callback(err);
                } else {
                    if (!self.images[0].imgData.sizes[sizeName].loaded) {
                        self.loadImages(arr, sizeName, function(imgArr) {
                            callback(null, imgArr);
                        });
                    } else {
                        callback(null, arr);
                    }
                }
            });
        },

        loadImages: function(images, sizeName, callback) {
            var self = this, arr = [];
            var load = function() {
                if (!images.length) {
                    callback(arr);
                    return;
                }
                var img = images.shift();

                new ImageLoader(img.thumbnail, function(err, result) {
                    if (!err) {
                        self.getImg(parseInt(img.id)).imgData.sizes[sizeName].loaded = true;
                        arr.push(img);
                    }
                    load();
                });
            };

            load();
        },

        getVideoImage: function (videoUrl, callback) {
            var self = this;
            if (videoUrl) {
                function createSizes (data) {
                    var result = {};
                    $.each(getThumbnailSizes(), function(index, size) {
                        if (size === 'thumbnail') {
                            result[size] = data.thumbnail;
                        } else {
                            result[size] = data.medium;
                        }
                    });
                    result['origin'] = data.medium;
                    result['custom'] = data.medium;
                    return result;
                }

                $($('<iframe>').attr('src', videoUrl)).MagicToolboxGalleryGetVideoImage(function(imgUrl) {
                    var value = null;

                    if (imgUrl) {
                        value =  {
                            id: new Date().getTime(),
                            type: 'video',
                            videoUrl: videoUrl,
                            url: imgUrl.thumbnail.url,
                            sizes: createSizes(imgUrl)
                        };
                    }
                    callback(value);
                }, true);
            }
        },

        findVideo: function(callback) {
            var self = this,
                index = 0,
                imgs = window.thumbnail_images,
                load = function () {
                    if (index < imgs.length) {
                        if (imgs[index].type === 'video') {
                            self.getVideoImage(imgs[index].videoUrl, function (obj) {
                                if (obj) { imgs[index] = obj; }
                                index += 1;
                                load();
                            });
                        } else {
                            index += 1;
                            load();
                        }
                    } else {
                        callback(imgs);
                    }
                };

            if (imgs.length) {
                load();
            } else {
                callback(imgs);
            }
        },

        load: function(imgs, callback) {
            var self = this,
                curtain = self.container.find('div.curtain');

            // imgs || (imgs = window.thumbnail_images);

            var load = function() {
                var img = imgs.shift();

                if (img) {
                    self.addToContainer($.extend({}, img), function() {
                        curtain.css({'height': self.container.height() + 'px'});
                        load();
                    });
                } else {
                    self.stopLoading();
                    self.setActive();
                    // tool.setTool();
                    if (self.images.length) {
                        errorNodes.defImage.css('display', '');
                        errorNodes.thumbnailsImages.css('display', '');
                        refrashButtonNode.css('display', 'inline-block');
                    }

                    if (callback) {
                        callback();
                    }
                }
            };

            if (!imgs) {
                this.findVideo(function (_imgs) {
                    imgs = _imgs;
                    if (imgs.length) {
                        self.startLoading();
                    }
                    load();
                });
            } else {
                load();
            }
        },

        lock: function() {
            this.addButton.prop('disabled', lockFlag);
            this.addVideoButton.prop('disabled', lockFlag);
            this.removeButton.prop('disabled', lockFlag);
        },

        setActive: function() {
            $.each(this.images, function(i, img) {
                img.setActive();
            });
        },

        removeImage: function(id) {
            var i, index;

            if (!isNaN(parseInt(id))) {
                for (i = 0; i < this.images.length; i++) {
                    var _img = this.images[i];
                    index = null;

                    if (_img.imgId === id) {
                        index = i;
                        tool.clean();
                        _img.wrapper.remove();
                        break;
                    }
                }

                if (null !== index) {
                    this.images.splice(index, 1);
                }
            } else {
                tool.clean();
                $.each(this.images, function(i, img) {
                    img.wrapper.remove();
                });
                this.images = [];
            }
            if (!this.images.length) {
                if (!mi.img) {
                    refrashButtonNode.css('display', 'none');
                }
                this.container.addClass('empty');
            }
            this.checkedVideoButton();
        },

        bEnable: function(value) {
            this.addButton.prop('disabled', !value);

            if (value && !this.images.length) { value = false; }
            this.addVideoButton.prop('disabled', !value);
        },

        createNode: function(imgData, size) {
            var self = this;
            var image = new this.ImageClass(imgData, size);

            $(image).on('remove-thumbnail', function(e, data) {
                self.removeImage(data.id);
                // tool.setTool();
            });

            this.images.push(image);

            return image.wrapper;
        },

        checkImg: function(url) {
            for (var i = 0; i < this.images.length; i++) {
                if (this.images[i].url === url) {
                    return true;
                }
            }
            return false;
        },

        addToContainer: function(imageData, callback) {
            var self = this;

            //if (this.checkImg(imageData.sizes.thumbnail.url)) {
            if (this.checkImg( imageData.sizes[ Object.keys(imageData.sizes)[0] ].url ) || imageData.sizes.thumbnail && this.checkImg(imageData.sizes.thumbnail.url)) {
                callback();
            } else {
                //new ImageLoader(imageData.sizes.thumbnail.url, function(err, result) {
                var $img = imageData.sizes[ Object.keys(imageData.sizes)[0] ].url;
                if (imageData.sizes.thumbnail) {
                    $img = imageData.sizes.thumbnail.url;
                }
                new ImageLoader($img, function(err, result) {
                    if (!err && result) {
                        self.imageWrapper.append(self.createNode(imageData, result.size));
                        self.container.removeClass('empty');
                    }
                    callback();
                });
            }
        },

        getData: function() {
            var self = this,
                str = '';

            $.each(this.images, function(i, img) {
                if (img.type === 'video') {
                    str += img.videoUrl;
                } else {
                    str += img.imgId;    
                }
                if (i !== self.images.length - 1) {
                    str += ',';
                }
            });

            return str;
        },

        startLoading: function() {
            saveButtonNodes.prop('disabled', true);
            saveAndCloseButtonNodes.prop('disabled', true);
            this.addButton.addClass('loading');
            this.addVideoButton.addClass('loading');
            this.bEnable(false);
            this.container.addClass('loading');
        },

        stopLoading: function() {
            saveButtonNodes.prop('disabled', false);
            saveAndCloseButtonNodes.prop('disabled', false);
            this.addButton.removeClass('loading');
            this.addVideoButton.removeClass('loading');
            this.bEnable(true);
            this.container.removeClass('loading');
        },

        checkedVideoButton: function () {
            var value = !this.images.length;
            if (this.images.length && this.images[0].type === 'video') {
                value = true;
                this.removeImage(this.images[0].imgData.id);
                if (this.images.length) {
                    this.checkedVideoButton();
                }
            }
            this.addVideoButton.prop('disabled', !this.images.length);
        }
    });

    function checkShortCode (id, shortcode, callback) {
        if (!toolId || '' === toolId) {
            toolId = 'null';
        }

        clearTimeout(shortcodeTimer);
        shortcodeTimer = setTimeout(function() {
            shortcodeNode.parent().addClass('loading');
        }, 300);

        shortcodeAjax = $.post(magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.ajax, {
            action: "WordPress_MagicZoomPlus_check_shortcode",
            nonce: magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.nonce,
            id: id,
            shortcode: shortcode
        })
        .success(function(_data) {
            _data = JSON.parse(_data);

            if (callback) {
                callback(null, _data);
            }
            clearTimeout(shortcodeTimer);
        })
        .error(function(e) {
            if (callback) {
                callback(e);
            }
            clearTimeout(shortcodeTimer);
        });
    }

    function setEvents() {
        var optNode = $('#custom-options-container'),
            optScrollNode = $('#magicscroll-custom-options'),
            refrashTimer, last;

        nameNode.on('focus', function() {
            errorNodes.name.css('display', '');
            nameNode.removeClass('its-error');
            nameNode.removeClass('its-ok');
        });

        nameNode.on('blur', function() {
            if ('' === $.trim(nameNode.val())) {
                nameNode.addClass('its-error');
            } else {
                nameNode.addClass('its-ok');
            }
        });

        shortcodeNode.on('keyup', function(e) {
            if (shortcodeIsValid($.trim(shortcodeNode.val()))) {
                errorNodes.shortcode.css('display', '');
                errorNodes.notUnique.css('display', '');
            } else {
                errorNodes.shortcode.css('display', 'inline-block');
            }
        });

        shortcodeNode.on('focus', function() {
            last = $.trim(shortcodeNode.val());
            shortcodeNode.removeClass('its-error');
            shortcodeNode.removeClass('its-ok');
        });

        shortcodeNode.on('blur', function() {
            var v = $.trim(shortcodeNode.val());
            if (shortcodeIsValid(v)) {
                if (shortcodeAjax) {
                    shortcodeAjax.abort();
                }
                if ('' !== $.trim(v) && last !== v) {
                    saveButtonNodes.prop('disabled', true);
                    saveAndCloseButtonNodes.prop('disabled', true);
                    checkShortCode(toolId, v, function(err, result) {
                        if (err) {
                            if ('abort' !== err.statusText) {
                                shortcodeNode.addClass('its-error');
                                shortcodeNode.removeClass('its-ok');
                            }
                        } else {
                            switch(result.error) {
                                case 'verification_failed':
                                case 'not_unique':
                                    console.log('error: ' + result.error);
                                    shortcodeNode.addClass('its-error');
                                    shortcodeNode.removeClass('its-ok');
                                    errorNodes.shortcode.css('display', '');
                                    errorNodes.notUnique.css('display', ('not_unique' === result.error) ? 'inline-block' : '');
                                    break;
                                default:
                                    shortcodeNode.removeClass('its-error');
                                    shortcodeNode.addClass('its-ok');
                            }
                        }
                        shortcodeAjax = null;
                        if (!err || 'abort' !== err.statusText) {
                            saveButtonNodes.prop('disabled', false);
                            saveAndCloseButtonNodes.prop('disabled', false);
                        }
                        shortcodeNode.parent().removeClass('loading');
                    });
                }
            } else {
                errorNodes.shortcode.css('display', 'inline-block');
            }
        });

        defImgSizeNode.on('change', function(e) {
            var v = $(this).val();

            $.each([d_iWidthNode, d_iHeightNode], function(i, n) {
                n.parent().css('display', 'custom' === v ? 'inline-block' : 'none');
            });
            // tool.setTool();
        });

        thumbImgSizeNode.on('change', function(e) {
            var v = $(this).val();

            $.each([t_iWidthNode, t_iHeightNode], function(i, n) {
                n.parent().css('display', 'custom' === v ? 'inline-block' : 'none');
            });
            // tool.setTool();
        });

        defaultRadio.on('change', function() {
            isCustomOptions = false;
            optNode.css('display', 'none');
            // tool.setTool();
        });

        customRadio.on('change', function() {
            isCustomOptions = true;
            optNode.css('display', 'block');
            // tool.setTool();
        });

        isCustomOptions = ('custom-options' === jQuery("input[type='radio'][name='settings']:checked").val());

        defaultScrollRadio.on('change', function() {
            isCustomScrollOptions = false;
            optScrollNode.css('display', 'none');
            // tool.setTool();
        });

        customScrollRadio.on('change', function() {
            isCustomScrollOptions = true;
            optScrollNode.css('display', 'block');
            // tool.setTool();
        });

        isCustomScrollOptions = ('custom-scroll-options' === jQuery("input[type='radio'][name='scrollsettings']:checked").val());

        saveButtonNodes.on('click', function(e) {
            save(function(err, data) {
                saveButtonNodes.parent().removeClass('loading');
                if (!err) {
                    if (isNaN(parseInt(toolId))) {
                        toolId = data.id;
                    }
                    $('#new-tool').css('display', 'none');
                    $.each($('#exist-tool').find('span'), function(i, el) {
                        el = $(el);
                        if (!i) {
                            el.html(toolId);
                        } else {
                            el.html(nameNode.val());
                        }
                    });
                    $('#exist-tool').css('display', 'block');

                    if (newTool) {
                        if (history.pushState) { history.pushState(null, null, '#' + toolId); }
                        else { location.hash = '#' + toolId; }
                    }
                }
                lock(true);
            });
        });

        saveAndCloseButtonNodes.on('click', function(e) {
            save(function(err) {
                if (err) {
                    lock(true);
                } else {
                    window.location.href = window.location.origin + window.location.pathname + window.location.search.split('&')[0];
                }
            });
        });

        closeButtonNodes.on('click', function(e) {
            window.location.href = window.location.origin + window.location.pathname + window.location.search.split('&')[0];
        });

        var sended = false;
        activatedLink.on('click', function (e) {
            e.preventDefault();
            e.stopPropagation();

            if (sended) { return; }
            sended = true;

            $.post(magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.ajax, {
                action: "WordPress_MagicZoomPlus_activate_magicscroll",
                nonce: magictoolbox_WordPress_MagicZoomPlus_admin_modal_object.nonce
            })
            .success(function(_data) {
                _data = JSON.parse(_data);
                sended = false;
                location.reload();
            })
            .error(function(e) {
                sended = false;
            });
        });
    }

    $(document).ready(function() {
        var container = $(document.body).find('.shortcode-container');

        // TODO correct parseOptions if attribute value is null or something like that
        globalMagicScrollOptions = parseOptions(container.attr('data-default-magicscroll-options'));

        globalOptions       = parseOptions(container.attr('data-default-options'));
        globalMobileOptions = parseOptions(container.attr('data-default-mobile-options'));
        toolId              = container.attr('data-tool-id');

        nameNode                = $('#tool-name-param');
        shortcodeNode           = $('#tool-shortcode-param');
        defImgSizeNode          = $('#default-img-size-param');
        thumbImgSizeNode        = $('#thumbnail-img-size-param');
        saveButtonNodes         = $('.save-button');
        saveAndCloseButtonNodes = $('.save-and-close-button');
        closeButtonNodes        = $('.close-button');
        defaultRadio            = $('#use-def-opt');
        customRadio             = $('#use-cus-opt');
        defaultScrollRadio      = $('#use-def-scroll-opt');
        customScrollRadio       = $('#use-cus-scroll-opt');
        // lockButtonNodes         = $('#custom-options-container').find('button');
        refrashButtonNode       = $('#refresh-button');
        d_iWidthNode            = $('#default-image-width-param');
        d_iHeightNode           = $('#default-image-height-param');
        t_iWidthNode            = $('#thumbnail-image-width-param');
        t_iHeightNode           = $('#thumbnail-image-height-param');
        thumbnailPositionNode   = $('#thumbnail-position-param');
        thumbnailModeNode       = $('#thumbnail-mode-param');
        activatedLink           = $('#activated-link');


        errorNodes.name             = $('#name-error');
        errorNodes.shortcode        = $('#shortcode-error');
        errorNodes.notUnique        = $('#shortcode-is-not-unique');
        errorNodes.defImage         = $('#default-image');
        errorNodes.loadImage        = $('#loading-error');
        errorNodes.thumbnailsImages = $('#thumbnails-images');


        mi            = new MainImage();
        ts            = new Thumbnails();
        tool          = new Tool();
        options       = new Options();

        setEvents();

        if (toolId && 'new' !== toolId && window.main_image) {
            newTool = false;
            lock();
            nameNode.val(container.attr('data-tool-name') || '');
            nameNode.blur();
            shortcodeNode.val(container.attr('data-tool-shortcode') || '');
            shortcodeNode.blur();
            mi.load(null, function() {
                ts.load(null, function() {
                    tool.setTool();
                    lock(true);
                });
            });
        } else {
            ts.checkedVideoButton();
        }
    });
})(jQuery);
