<?php add_thickbox(); ?>

<div class="wrap">

    <h1><?php esc_html_e( 'WeCreativez WhatsApp Support - Analytics', 'wc-wws' ) ?></h1>

    <?php do_action( 'wws_admin_notifications' ); ?>
    
    <hr>

    <h3><?php esc_html_e( 'Total Clicks Analytics', 'wc-wws' ) ?></h3>

    <div class="flex-grid flex-grid-3">
        <div class="col">
            <div class="wws-admin-card filled">
                <h1><?php echo esc_html( $total_clicks ) ?></h1>
                <p><i class="wws-icon-mouse-pointer"></i> <?php echo esc_html_e( 'Total Clicks', 'wc-wws' ) ?></p>
            </div>
        </div>
        <div class="col">
            <div class="wws-admin-card filled">
                <h1><?php echo esc_html( $total_clicks_by_desktop ) ?></h1>
                <p><i class="wws-icon-desktop"></i> <?php echo esc_html_e( 'Total Clicks By Desktop/ Laptop', 'wc-wws' ) ?></p>
            </div>
        </div>
        <div class="col">
            <div class="wws-admin-card filled">
                <h1><?php echo esc_html( $total_clicks_by_mobile ) ?></h1>
                <p><i class="wws-icon-mobile"></i> <?php echo esc_html_e( 'Total Clicks By Mobile', 'wc-wws' ) ?></p>
            </div>
        </div>
    </div>

    <hr>

    <h3><?php esc_html_e( 'Complete Analytics', 'wc-wws' ); ?></h3>

    <?php
        $analytics_table = apply_filters( 'wws_analytics_table', array(
            'visitor_ip'    => esc_html__( 'Visitors IP', 'wc-wws' ),
            'number'        => esc_html__( 'Number', 'wc-wws' ),
            'message'       => esc_html__( 'Message', 'wc-wws' ),
            'referral'      => esc_html__( 'Referral', 'wc-wws' ),
            'device_type'   => esc_html__( 'Device Type', 'wc-wws' ),
            'os'            => esc_html__( 'OS', 'wc-wws' ),
            'browser'       => esc_html__( 'Browser', 'wc-wws' ),
            'date'          => esc_html__( 'Date', 'wc-wws' ),
            'action'        => esc_html__( 'Action', 'wc-wws' ),
        ) );
    ?>

    <table class="wp-list-table widefat fixed striped wws-admin-datatable">
        <thead>
            <tr>
                <th>#</th>
                <?php foreach( $analytics_table as $at ) : ?>
                    <th><?php echo $at; // WPCS: XSS OK ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php
                $sr = 1;
                foreach ( $analytics as $v ) :
            ?>
                <tr>
                    <td><?php echo $sr; ?></td>
                    <?php foreach( $analytics_table as $at_key => $at ) : ?>
                        <?php if ( $at_key === 'action' ) { continue; } ?>
                        <td><?php echo $v[$at_key]; // WPCS: XSS OK ?></td>
                    <?php endforeach; ?>
                    <?php if ( $at_key === 'action' ) : ?>
                        <td>
                            <i class="button button-primary wws-icon-eye" data-ip="<?php echo esc_attr( $v['visitor_ip'] ) ?>"></i>
                            <a href="?wws_delete_analytics=<?php echo intval( $v['id'] ) ?>" class="button button-secondary"><i class="wws-icon-trash"></i></a>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php
                $sr++;
                endforeach;
            ?>
        
        </tbody>
        <tfoot>
            <tr>
                <th>#</th>
                <?php foreach( $analytics_table as $at ) : ?>
                    <th><?php echo $at; // WPCS: XSS OK ?></th>
                <?php endforeach; ?>
            </tr>
        </tfoot>
    </table>

    <hr>

    <div>
        
        <a href="?wws_delete_complete_analytics=1" class="button button-secondary" onclick="return confirm('<?php esc_html_e( 'Are you sure?', 'wc-wws' ) ?>')">
            <?php esc_html_e( 'Delete Complete Analytics', 'wc-wws' ) ?>
        </a>

    </div>

    <hr>

    <div>
        
        <p><?php wp_kses_post( _e( '<strong>N/A</strong> means not applicable for the selected layout.', 'wc-wws' ) )?></p>

    </div>

</div>